{$M $FF02,0,65535}
{$F+,i-,r-,s-,d+,g+}

unit BASPAS;

interface

procedure CloseUpFormation;
procedure ShowCursor;
procedure Shell (Tekst : string);
procedure Screen (Mode : integer);
procedure Cirkel (x, y, r : integer);
procedure Point (a,b : integer);
procedure Lijn (x1,y1, x2,y2 : integer);
procedure AtXY (a, b : integer);
procedure _readln (var Tekst : string);
procedure _write (Tekst : string);
procedure Print (Tekst : string);
procedure PrintReal (R : real);
procedure PrintInteger (Getal : longint);
procedure Ink (Colour : integer);
procedure Paper (Colour : integer);
procedure Color (ForeGround, BackGround : integer);
function MidStr (Tekst : string; a,b : integer) : string;
function LeftStr (Tekst : string; number : integer) : string;
function RightStr (Tekst : string; number : integer) : string;

const
  TextScreenAddress : word = $B800;

var
  _Ink, _Paper     : integer;

implementation

uses
  crt, dos, graph;

const
  MaxCursorY : array[0..13] of integer = (
    25, 25, 0, 60, 0, 0, 0, 25, 0, 0, 50, 0, 0, 25
  );
  MaxCursorX : array[0..13] of integer = (
    80, 40, 0, 80, 0, 0, 0, 40, 0, 0, 80, 0, 0, 40
  );

var
  ScreenMode       : integer;
  CursorX, CursorY : integer;
  Old1C            : pointer;

procedure EGAVGADriver; external;
  {$L EGAVGA.OBJ}

procedure CGADriver; external;
  {$L CGA.OBJ}

procedure ShowCursor;
  var
    adress              : word;
    ChB                 : byte;
    a,b,c,d, q          : integer;
    p                   : pointer;
    size                : longint;
    SavedPortion        : array[0..7, 0..7] of byte;
  begin
    case ScreenMode of
      13: begin
        directvideo:= false;
        textcolor (_Ink);
        a:= (CursorX-1)*8;
        b:= (CursorY-1)*8;
        for c:= a to a+7 do
          for d:= b to b+7 do
            SavedPortion [c-a][d-b]:= mem[$a000: c + d*320];
        gotoxy (CursorX, CursorY);
        write (#177);
        gotoxy (CursorX, CursorY);
        delay (37);
        for c:= a to a+7 do
          for d:= b to b+7 do
            mem[$a000: c + d*320]:= SavedPortion[c-a][d-b];
        delay (37);
      end;
      0, 7, 10: begin
        directvideo:= false;
        textcolor (_Ink);
        adress:= (CursorX-1)*2 + CursorY*160;
        ChB:= mem[textscreenaddress:adress];
        gotoxy (CursorX, CursorY);
        write (#177);
        gotoxy (CursorX, CursorY);
        delay (37);
        gotoxy (CursorX, CursorY);
        write (#32);
        delay (37);
        gotoxy (CursorX, CursorY);
        write (char(ChB));
        gotoxy (CursorX, CursorY);
        delay (37);
      end;
      1, 3: begin
        setcolor (_Ink);
        a:= (CursorX-1)*textwidth('H');
        b:= (CursorY-1)*textheight('H');
        c:= a+textwidth('H');
        d:= b+textheight('H');
        size:= imagesize (a,b, c, d);
        getmem (p, size);
        getimage (a,b, c,d, p^);
        setcolor (_Paper);
        for q:= a to b do
          line (q, b, q, d);
        delay (37);
        setcolor (_Ink);
        outtextxy (a,b, #177);
        delay (37);
        putimage (a,b, p^, NormalPut);
        freemem (p, size);
        delay (37);
      end;
    end;
  end;

procedure CloseUpFormation;
  begin
 (*   setintvec ($1c, Old1C);*)
 (*  CursorOn;               *)
  end;

procedure Shell (Tekst : string);
  begin
    swapvectors;
    exec (getenv ('COMSPEC'), '/C '+Tekst);
    swapvectors;
  end;

procedure Ink (Colour : integer);
  begin
    case ScreenMode of
      1: _Ink:= Colour;
      else _Ink:= Colour mod 16;
    end;
    case ScreenMode of
      1, 3: begin
        setcolor (_Ink);
        setbkcolor (_Paper);
      end;
      else begin
        textcolor (_Ink);
        textbackground (_Paper);
      end;
    end;
  end;

procedure Paper (Colour : integer);
  begin
    case ScreenMode of
      1: _Paper:= Colour mod 4;
      else _Paper:= Colour mod 16;
    end;
    case ScreenMode of
      1, 3: begin
        setcolor (_Ink);
        setbkcolor (_Paper);
      end;
      else begin
        textcolor (_Ink);
        textbackground (_Paper);
      end;
    end;
  end;

procedure Color (ForeGround, BackGround : integer);
  begin
    Ink (ForeGround);
    Paper (BackGround);
  end;

procedure Screen (Mode : integer);
  var
    GraphicsDriver, GraphicsMode : integer;
  begin
    if Mode in [0..13] then begin
      ScreenMode:= Mode;
      case Mode of
        0: textmode (co80);
        1: begin
          GraphicsDriver:= cga;
          GraphicsMode:= cgac0;
          initgraph (GraphicsDriver, GraphicsMode, '');
          settextstyle (defaultfont, horizdir, 1);
        end;
        3: begin
          GraphicsDriver:= vga;
          GraphicsMode:= vgahi;
          initgraph (GraphicsDriver, GraphicsMode, '');
          settextstyle (defaultfont, horizdir, 1);
        end;
        7: textmode (co40);
        10: textmode (co80+Font8x8);
        13: begin
          asm
            mov ax,$13;
            int $10;
          end;
        end;
      end;
      case Mode of
        0, 7, 10: begin
          textbackground (_Paper);
          textcolor (_Ink);
          clrscr;
        end;
        1, 3: begin
          setbkcolor (_Paper);
          cleardevice;
          setcolor (_Ink);
        end;
      end;
    end;
  end;

procedure Cirkel (x, y, r : integer);
  var
    c, temp : word;   { temp is absolute offset here .... .. }
    xx, yy  : real;
  begin
    case ScreenMode of
      0, 7, 10: begin
        textcolor (_Ink);
        c:= 0;
        repeat
          yy:= r * sin(c);
          xx:= r * cos(c);
          temp:= (round(xx)+x)*2 + (round(yy)+y)*160;
          mem[textscreenaddress:temp]:= byte(#177);
          mem[textscreenaddress:temp + 1]:= textattr;
          c:= c + 3;
        until c>360;
      end;
      13: begin
        c:= 0;
        repeat
          yy:= r * sin(c);
          xx:= r * cos(c);
          temp:= (round(xx)+x) + (round (yy)+y)*320;
          mem[$a000:temp]:= _Ink;
          c:= c + 3;
        until c > 360;
      end;
      1, 3: begin
        setcolor (_Ink);
        circle (x,y, r);
      end;
    end;
  end;

procedure Point (a,b : integer);
  var
    temp : word;
  begin
    case ScreenMode of
      0, 7, 10: begin
          temp:= a*2 + b*160;
          mem[textscreenaddress:temp]:= byte(#177);
          mem[textscreenaddress:temp + 1]:= textattr;
      end;
      1, 3: begin
        setcolor (_Ink);
        putpixel (a,b, _Ink);
      end;
      13: begin
        mem[$a000:a + b*320]:= _Ink;
      end;
    end;
  end;

  procedure wissel (var a : integer; var b : integer);
    var
      hulp : integer;
    begin
      hulp:= a;
      a:= b;
      b:= hulp;
    end;

procedure Lijn (x1,y1, x2,y2 : integer);
  var
    xx, yy : real;
    dx, dy : integer;
    m      : real;
  procedure vertical_line;
    var
      c : integer;
    begin
      case ScreenMode of
        0, 7, 10: begin
          textcolor (_Ink);
          for c:= y1 to y2 do
            Point (x1, c);
        end;
        13: begin
          for c:= y1 to y2 do
            Point (x1, c);
        end;
        1, 3: begin
          setcolor (_Ink);
          line (x1,y1, x1,y2);
        end;
      end;
    end;
  procedure horizontal_line;
    var
      c : integer;
    begin
      case ScreenMode of
        0, 7, 10: begin
          textcolor (_Ink);
          for c:= x1 to x2 do
            Point (c, y1);
        end;
        13: begin
          for c:= x1 to x2 do
            Point (c, y1);
        end;
        1, 3: begin
          setcolor (_Ink);
          line (x1,y1, x2,y1);
        end;
      end;
    end;
  begin
    if (x2 < x1) then wissel (x1, x2);
    if (y2 < y1) then wissel (y1, y2);
    dx:= abs(x2-x1);
    dy:= abs(y2-y1);
    if (dx=0) and (dy > 0) then begin
      vertical_line;
      exit;
    end;
    if (dy=0) and (dx > 0) then begin
      horizontal_line;
      exit;
    end;
    if (dx=0) and (dy=0) then begin
      case ScreenMode of
        0, 7, 10: begin
          textcolor (_Ink);
          Point (x1, y1);
        end;
        13: Point (x1, y1);
        1, 3: begin
          setcolor (_Ink);
          PutPixel (x1,y1, _Ink);
        end;
      end;
      exit;
    end;
    case ScreenMode of
      0, 7, 10, 13: begin
        if ScreenMode <> 13 then textcolor (_Ink);
        xx:= x1;
        m:= dy/dx;
        repeat
          yy:= m*xx + x1;
          xx:= xx+0.37;
          Point (round (xx), round(yy));
        until xx > x2;
      end;
      1, 3: begin
        setcolor (_Ink);
        line (x1,y1, x2,y2);
      end;
    end;
  end;

procedure AtXY (a,b : integer);
  begin
      case ScreenMode of
        0: begin
          CursorX:= a mod 80;
          if b = 25 then
            CursorY:= 25
              else
                CursorY:= b mod 25;
        end;
        7: begin
          CursorX:= a mod 40;
          if b = 25 then
            CursorY:= 25
              else
                CursorY:= b mod 25;
        end;
        10: begin
          CursorX:= a mod 80;
          if b = 50 then
            CursorY:= 50
              else
                CursorY:= b mod 50;
        end;
        13: begin
          CursorX:= a mod 40;
          if b = 25 then
            CursorY:= 25
              else
                CursorY:= CursorY mod 25;
        end;
        1: begin
          CursorX:= a mod ((getmaxx+1) div textwidth('H'));
          if b=25 then
            CursorY:= 25
              else
                CursorY:= b mod ((getmaxy+1) div textheight('H'));
        end;
        3: begin
          CursorX:= a mod ((getmaxx+1) div textwidth('H'));
          if b=60 then
            CursorY:= 60
              else
                CursorY:= b mod ((getmaxy+1) div textheight('H'));
        end;
      end;
      directvideo:= false;
      gotoxy (CursorX, CursorY);
  end;

procedure _readln (var Tekst : string);
  var
    Ch : char;
    a,b: integer;
  begin
    case ScreenMode of
      0, 7, 10: begin
        textcolor (_Ink);
      end;
      1, 3: begin
        setcolor (_Ink);
      end;
    end;
    Tekst:= '';
    a:= CursorX;
    repeat
      case ScreenMode of
        0, 7, 10, 13: begin
          textcolor (_Ink);
          textbackground (_Paper);
          directvideo:= false;
          gotoxy (a, CursorY);
          write (Tekst+#32);
        end;
        1, 3: begin
          setcolor (_Ink);
          directvideo:= false;
          AtXY (a, CursorY);
          outtextxy ((a-1)*textwidth('H'), (CursorY - 1)*textheight('H'),
            Tekst);
          outtextxy ((a-1)*textwidth('H'), (CursorY - 1)*textheight('H'),
            Tekst);
          setcolor (_Paper);
          outtextxy ((a-1)*textwidth('H')+textwidth(Tekst),
                     (CursorY - 1)*TextHeight ('H'), #175);
          outtextxy ((a-1)*textwidth('H')+textwidth(Tekst),
                     (CursorY - 1)*TextHeight ('H'), #176);
          outtextxy ((a-1)*textwidth('H')+textwidth(Tekst),
                     (CursorY - 1)*TextHeight ('H'), #177);
          outtextxy ((a-1)*textwidth('H')+textwidth(Tekst),
                     (CursorY - 1)*TextHeight ('H'), #2);
          outtextxy ((a-1)*textwidth('H')+textwidth(Tekst),
                     (CursorY - 1)*TextHeight ('H'), #1);
        end;
      end;
      AtXY (a+length(Tekst), CursorY);
      repeat
        directvideo:= false;
        ShowCursor;
      until keypressed;
      Ch:= readkey;
      if Ch = #8 then begin
        Tekst:= copy (Tekst, 1, length(Tekst)-1);
      end else if (Ch <> #13) and (Ch <> #0) and (Ch <> #27) then begin
        if length(Tekst)+a < MAXCURSORX[ScreenMode]-1 then
          Tekst:= Tekst + Ch;
      end;
    until Ch = #13;
    directvideo:= false;
    writeln;
    AtXY (1, CursorY+1);
  end;

procedure Print (Tekst : string);
  var
    c, a, b : integer;
    P       : pointer;
    Size    : integer;
  begin
    directvideo:= false;
    case ScreenMode of
      0, 7, 10, 13: begin
        textcolor (_Ink);
        if ScreenMode <> 13 then textbackground (_Paper);
      end;
      1, 3: begin
        setcolor (_Ink);
      end;
    end;
    directvideo:= false;
    for c:= 1 to length(Tekst) do begin
      directvideo:= false;
      case ScreenMode of
        0, 7, 10, 13: begin
          textcolor (_Ink);
          if ScreenMode <> 13 then textbackground (_Paper);
          gotoxy (CursorX, CursorY);
          write (Tekst[c]);
        end;
        1, 3: begin
          setcolor (_Ink);
          outtextxy ((CursorX-1)*textwidth('H'),
                     (CursorY-1)*textheight('H'),
                     Tekst[c]
          );
        end;
      end;
      CursorX:= CursorX + 1;
      if CursorX > MaxCursorX[ScreenMode] then begin
        CursorX:= 1;
        CursorY:= CursorY + 1;
        if CursorY > MaxCursorY[ScreenMode] then begin
(*          if ScreenMode = 13 then begin
            move (mem[$a000:8*320], mem[$a000:0], 61440);
            fillchar (mem[$a000:61440], 8*320, 0);
          end;
*)
          if ScreenMode in [1, 3] then begin
            CursorY:= MaxCursorY[ScreenMode];
            directvideo:= false;
            CursorX:= 1;
            if ScreenMode = 3 then begin
              Size:= imagesize (0,0, getmaxx, 11);
              getmem (P, Size);
              for b:= 0 to (getmaxy+1) div 8-1 do begin
                  getimage (0,(b+1)*8, getmaxx,b*8 + 16, P^);
                  putimage (0,b*8, P^, NormalPut);
              end;
              freemem (P, Size);
            end;
            if ScreenMode = 1 then begin
              Size:= imagesize (0,0, getmaxx, 11);
              getmem (P, Size);
              for b:= 0 to (getmaxy+1) div 8-1 do begin
                  getimage (0,(b+1)*8, getmaxx,b*8 + 16, P^);
                  putimage (0,b*8, P^, NormalPut);
              end;
              freemem (P, Size);
            end;
            case ScreenMode of
              1: begin
                setcolor(_Paper);
                for a:= getmaxy downto getmaxy-8 do
                  line (0,a, getmaxx,a);
              end;
              3: begin
                setcolor(_Paper);
                for a:= getmaxy downto getmaxy-8 do
                  line (0,a, getmaxx,a);
              end;
            end;
          end else begin
            CursorY:= MaxCursorY[ScreenMode];
            directvideo:= false;
            gotoxy (1, MaxCursorY[ScreenMode]);
            writeln;
            CursorX:= 1;
          end;
        end;
      end;
    end;
    CursorY:= CursorY+1;
    CursorX:= 1;
    if CursorY > MaxCursorY[ScreenMode] then begin
(*      if ScreenMode = 13 then begin
        move (mem[$a000:8*320-1], mem[$a000:0], 61440);
        fillchar (mem[$a000:61440-1], 8*320, 0);
      end;
*)
      if ScreenMode in [1, 3] then begin
        CursorY:= MaxCursorY[ScreenMode];
        directvideo:= false;
        CursorX:= 1;
        if ScreenMode = 3 then begin
          Size:= imagesize (0,0, getmaxx, 11);
          getmem (P, Size);
          for b:= 0 to (getmaxy+1) div 8-1 do begin
              getimage (0,(b+1)*8, getmaxx,b*8 + 16, P^);
              putimage (0,b*8, P^, NormalPut);
          end;
          freemem (P, Size);
        end;
        if ScreenMode = 1 then begin
          Size:= imagesize (0,0, getmaxx, 11);
          getmem (P, Size);
          for b:= 0 to (getmaxy+1) div 8-1 do begin
              getimage (0,(b+1)*8, getmaxx,b*8 + 16, P^);
              putimage (0,b*8, P^, NormalPut);
          end;
          freemem (P, Size);
        end;
        case ScreenMode of
          1: begin
            setcolor(_Paper);
            for a:= getmaxy downto getmaxy-8 do
              line (0,a, getmaxx,a);
          end;
          3: begin
            setcolor(_Paper);
            for a:= getmaxy downto getmaxy-8 do
              line (0,a, getmaxx,a);
          end;
        end;
      end else begin
        CursorY:= MaxCursorY[ScreenMode];
        directvideo:= false;
        gotoxy (1, MaxCursorY[ScreenMode]);
        writeln;
        CursorX:= 1;
      end;
    end;

    AtXY (1, CursorY);

  end;

procedure PrintReal (R : real);
  var
    Tekst : string;
  begin
    str (R : 11 : 5, Tekst);
    Print (Tekst);
    exit
  end;

procedure PrintInteger (Getal : longint);
  var
    Tekst : string;
  begin
    str (Getal, Tekst);
    Print (Tekst);
    exit
  end;

procedure _write (Tekst : string);
  var
    c, a, b : integer;
    P       : pointer;
    Size    : integer;
  begin
    directvideo:= false;
    case ScreenMode of
      0, 7, 10, 13: begin
        textcolor (_Ink);
        if ScreenMode <> 13 then textbackground (_Paper);
      end;
      1, 3: begin
        setcolor (_Ink);
      end;
    end;
    directvideo:= false;
    for c:= 1 to length(Tekst) do begin
      directvideo:= false;
      case ScreenMode of
        0, 7, 10, 13: begin
          textcolor (_Ink);
          if ScreenMode <> 13 then textbackground (_Paper);
          gotoxy (CursorX, CursorY);
          write (Tekst[c]);
        end;
        1, 3: begin
          setcolor (_Ink);
          outtextxy ((CursorX-1)*textwidth('H'),
                     (CursorY-1)*textheight('H'),
                     Tekst[c]
          );
        end;
      end;
      CursorX:= CursorX + 1;
      if CursorX > MaxCursorX[ScreenMode] then begin
        CursorX:= 1;
        CursorY:= CursorY + 1;
        if CursorY > MaxCursorY[ScreenMode] then begin
(*          if ScreenMode = 13 then begin
            move (mem[$a000:8*320], mem[$a000:0], 61440);
            fillchar (mem[$a000:61440], 8*320, 0);
          end;
*)
          if ScreenMode in [1, 3] then begin
            CursorY:= MaxCursorY[ScreenMode];
            directvideo:= false;
            CursorX:= 1;
            if ScreenMode = 3 then begin
              Size:= imagesize (0,0, getmaxx, 11);
              getmem (P, Size);
              for b:= 0 to (getmaxy+1) div 8-1 do begin
                  getimage (0,(b+1)*8, getmaxx,b*8 + 16, P^);
                  putimage (0,b*8, P^, NormalPut);
              end;
              freemem (P, Size);
            end;
            if ScreenMode = 1 then begin
              Size:= imagesize (0,0, getmaxx, 11);
              getmem (P, Size);
              for b:= 0 to (getmaxy+1) div 8-1 do begin
                  getimage (0,(b+1)*8, getmaxx,b*8 + 16, P^);
                  putimage (0,b*8, P^, NormalPut);
              end;
              freemem (P, Size);
            end;
            case ScreenMode of
              1: begin
                setcolor(_Paper);
                for a:= getmaxy downto getmaxy-8 do
                  line (0,a, getmaxx,a);
              end;
              3: begin
                setcolor(_Paper);
                for a:= getmaxy downto getmaxy-8 do
                  line (0,a, getmaxx,a);
              end;
            end;
          end else begin
            CursorY:= MaxCursorY[ScreenMode];
            directvideo:= false;
            gotoxy (1, MaxCursorY[ScreenMode]);
            writeln;
            CursorX:= 1;
          end;
        end;
      end;
    end;
  end;

function MidStr (Tekst : string; a,b : integer) : string;
  begin
    MidStr:= copy (Tekst, a, b);
  end;

function LeftStr (Tekst : string; number : integer) : string;
  begin
    LeftStr:= copy (Tekst, 1, number);
  end;

function RightStr (Tekst : string; number : integer) : string;
  var
    Len : integer;
  begin
    Len := length (Tekst);
    RightStr:= copy (Tekst, Len-Number+1, Number);
  end;

begin
  directvideo:= false;
  registerbgidriver (addr(EGAVGADriver));
  registerbgidriver (addr(CGADriver));
(*  getintvec ($1C, Old1C);
  setintvec ($1C, addr (ShowCursor));
*)
  _Ink:= LIGHTGRAY;
  _Paper:= BLACK;
  CursorX:= 1;
  CursorY:= 1;
  ScreenMode:= 0;
  Screen (ScreenMode);
end.