{$m $ff02,0,65535}
{$r-,s-,i-.d+,g-}

program SpaceInvaders (input, output);

uses
  crt, BASPAS, graph, MUSIC;

  var
    buffer       : array[0..4001] of shortint;
    dosx, dosy   : integer;

    score        : longint;
    GAMEOVER     : boolean;

  type
    Collision = boolean;
    tUpDown   = (Up, Down);

  type
    tShipPtr   = ^tShip;
    tShip      = object
      Sprite : pointer;
      Size   : word;
      x, y   : integer;
      Lives  : integer;
      _Alive : boolean;

      procedure SetLives (TotalLives : integer);
      procedure GetSprite (a,b, c,d : integer);
      procedure PutSprite;
      procedure DestroySprite;
      function WhoIsThere (a, b : integer) : word;
      function Shoot (UpOrDown : tUpDown) : Collision;
      function Alive : boolean;
    end;

  var
    You    : tShip;
    Alien  : array[1..7, 1..3] of tShip;
    Player : tShip;

procedure tShip.SetLives (TotalLives : integer);
  begin
    Lives:= TotalLives;
    if Lives <= 0 then _Alive:= false else _Alive:= true;
    exit;
  end;

procedure tShip.GetSprite (a,b, c,d : integer);
  begin
    Size:= ImageSize (a,b, c,d);
    getmem (Sprite, Size);
    getimage (a,b, c,d, Sprite^);
    x:= a;
    y:= b;
    exit;
  end;

procedure tShip.PutSprite;
  begin
    PutImage (x, y, Sprite^, NormalPut);
    exit;
  end;

function tShip.Alive : boolean;
  begin
    Alive:= _Alive;
  end;

procedure tShip.DestroySprite;
  begin
    freemem (Sprite, Size);
    x:= 0;
    y:= 0;
    _Alive:= false;
    exit;
  end;

  procedure InitSprites;
    var
      c : integer;
    begin
      Paper (BLACK);
      INK (LIGHTGRAY);
      Screen (3);
      settextstyle (defaultfont, horizdir, 2);
      cleardevice;

      Ink (RED);
      Lijn (16, 16, 32, 0);
      for c:= 0 to 11 do
        Lijn (32, 0, 32+(32-8), 16-c);
      Ink (Brown);
      Lijn (8, 16, 32+(32-8), 16);
      Ink (Yellow);
      cirkel ((32+(32-8)+8) div 2, 13, 7);

      for c:= 1 to 7 do begin
        ALien[c, 1].GetSprite (0,0, 37, 37);
        Alien[c, 1].x:= 11+(c-1)*51;
        Alien[c, 1].y:= 47;
        Alien[c, 1]._Alive:= true;
        Alien[c, 1].Lives:= 3;
      end;
      cleardevice;

      setcolor (lightcyan);
      outtextxy (7,7, '{^^}');
      outtextxy (7+8, 7+8, '\/');
      for c:= 1 to 7 do begin
        ALien[c, 2].GetSprite (0,0, 35, 35);
        Alien[c, 2].x:= 13+(c-1)*57;
        Alien[c, 2].y:= 133;
        Alien[c, 2]._Alive:= true;
        Alien[c, 2].Lives:= 2;
      end;
      cleardevice;

      setcolor (blue);
      outtextxy (7, 7, '[-0-]');
      for c:= 1 to 7 do begin
        Alien[c, 3].GetSprite (0, 0, 45, 27);
        ALien[c, 3].x:= 17+(c-1)*55;
        Alien[c, 3].y:= 177;
        Alien[c, 3]._Alive:= true;
        Alien[c, 3].Lives:= 1;
      end;

      cleardevice;
      setcolor (white);
      outtextxy (7, 7, ' ! ');
      outtextxy (7, 7+8, '/ \');
      setcolor (red);
      outtextxy (7, 7+16,'###');

      Player.GetSprite (0,0, 37,57);
      Player.x:= getmaxx div 2;
      Player.y:= getmaxy - 37;
      Player.Lives:= 5;
      Player._ALive:= true;
      cleardevice;
    end;

function tShip.WhoIsThere (a, b : integer) : word;
  var
    c, c2 : integer;
  begin
    for c:= 1 to 7 do
      for c2:= 3 downto 1 do
        if Alien[c, c2].Alive and (a >= ALien[c, c2].x -11) and (a <= Alien[c, c2].x + 31)
             then begin
               WhoIsThere:= (((c)*256)+(c2));
               exit;
             end;
    WhoIsThere:= 0;
    exit;
  end;

function tShip.Shoot (UpOrDown : tUpDown) : Collision;
  var
    c : integer;
  begin
    case UpOrDown of
      Up: for c:= 33 to 777 do sound (55+random(c)+77);
      Down: playmusicforeground ('l64acacacffabcabc');
    end;
    nosound;
    MusicOff;
    case UpOrDown of
      Down: begin
        setcolor (lightred);
        lijn (x, y, x, getmaxy);
        lijn (x+1, y, x+1, getmaxy);
        if (Player.x >= x-11) and (Player.x <= x+21) then begin
          sound (777);
          delay (33);
          sound (337);
          delay (51);
          nosound;
          dec (Player.Lives, 1);
          GAMEOVER:= (Player.Lives = 0);
          if GameOver then Player._Alive:= false;
        end;
      end;
      Up: begin
        setcolor (lightgreen);
        lijn (player.x, player.y, player.x, 0);
        lijn (player.x+1, player.y, player.x+1, 0);
        c:= Player.WhoIsThere (player.x, player.y);
        if c > 0 then begin
          dec (Alien[c div 256, c mod 256].Lives, 1);
          if Alien[c div 256, c mod 256].Lives = 0 then
            ALien[c div 256, c mod 256]._Alive:= false;
          inc (Score, (c div 257)*110);
        end;
      end;
    end;
    delay (337);
  end;

procedure DrawScreen;
  var
    c, c2 : longint;
    tekst : string;
  begin
    setbkcolor (0);
    cleardevice;
    for c:= 1 to 7 do
      for c2:= 1 to 3 do
        with Alien[c, c2] do begin
          if _Alive then PutSprite;
        end;
    if Player._Alive then Player.PutSprite;
    str (score, tekst);
    setcolor (yellow);
    outtextxy (0, 0, 'score == '+tekst);
    setcolor (brown);
    str (Player.Lives, Tekst);
    outtextxy (377,0, 'lives == '+tekst);
  end;

var
    Plus  : integer;

procedure AnimateEnemies;
  var
    c, c2 : integer;
  begin
    for c:= 1 to 7 do
      for c2:= 1 to 3 do begin
        with Alien[c, c2] do begin
          x:= x + Plus;
          if x > 601 then
            Plus:= -3;
          if x < 55 then
            Plus:= 3;
        end;
      end;
    DrawScreen;
  end;

  var
    Ch, Inkey, KeyPress, Toets, Key : char;
    a, b                            : integer;
    Tekst                           : string;

begin
  Plus:= 3;
  Score:= 0;
  GAMEOVER:= false;
  nosound;
  randomize;
  move (mem[$b800:0], buffer, 4000);
  dosx:= wherex;
  dosy:= wherey;

  Screen (3);
  settextstyle (defaultfont, horizdir, 2);

  repeat
    InitSprites;
    repeat
      repeat
         AnimateEnemies;
         delay (111);
         if random (17) = 13 then begin
           a:= random (7) + 1;
           b:= random (3) + 1;
           if Alien[a, b].Alive then
           Alien[a, b].Shoot (Down);
         end;
      until KeyPressed;
      Ch:= readkey;
      if Ch = #32 then Player.Shoot (Up);
      if Ch = #0 then begin
        Ch:= readkey;
        case Ch of
          'K': if Player.x > 45 then dec (Player.X, 7);
          'M': if Player.x < 605 then inc (Player.X, 7);
        end;
      end;
    until (Ch = #27) or GAMEOVER;
    cleardevice;
    str (Score, Tekst);
    outtextxy (0, 0, 'Your score == '+Tekst);
    outtextxy (51, 77, 'Play again? [y/n]? ');
    repeat
      Ch:= UpCase (ReadKey);
    until Ch in ['Y', 'N'];
  until Ch = 'N';    { Again ?no--> exit repeat loop  ... .... ..}
  Ink (LIGHTGRAY);
  Paper (BLACK);
  closegraph;
  textmode (co80);
  move (buffer, mem[$b800:0], 4000);
  gotoxy (dosx, dosy);
  halt (0);
end.
+
+
+
+
