{$F+,I-}
{$M $FF02,0,65535}

unit CORE;

interface

uses
  crt, graph;

procedure PRINTVGA (X, Y : integer; TEKST : string);
procedure PRINTMCGA (TEKST : string);
procedure VGAINIT;
procedure MCGAINIT;

implementation

procedure EGAVGADriver; external;
  {$L EGAVGA.OBJ}

procedure PRINTVGA (X, Y : integer; TEKST : string);
  var
    BColor, FColor : integer;
    OldGraphColor  : integer;
  begin
    OldGraphColor:= getcolor;
    BColor:= textattr div 16;
    FColor:= textattr mod 16;
    settextstyle (defaultfont, horizdir, 1);
    setfillstyle (solidfill, BColor);
    setcolor (BColor);
    bar (X,Y, X+length(TEKST)*textwidth ('H')-1, Y+textheight('H')-1);
    setcolor (FColor);
    outtextxy (X, Y, TEKST);
    setcolor (OldGraphColor);
  end;

procedure PRINTMCGA (TEKST : string);
  var
    X, Y            : integer;
    A, B            : integer;
    FColor, BColor  : integer;
    Address         : word;
  begin
    BColor:= textattr div 16;
    FColor:= textattr mod 16;
    X:= wherex;
    Y:= wherey;
    gotoxy (X, Y);
    textcolor (FColor);
    write (TEKST);
    for B:= (Y-1)*8 to Y*8 do
      for A:= (X-1)*8 to (X+length(TEKST)-1)*8 do begin
        Address:= A + B*320;
        if mem[$A000:Address] = 0 then
          mem[$A000:Address]:= BColor;
      end;
  end;

procedure VGAINIT;
  var
    GraphicsDriver, GraphicsMode : integer;
  begin
    GraphicsDriver:= vga;
    GraphicsMode:= vgahi;
    initgraph (GraphicsDriver, GraphicsMode, '');
    directvideo:= false;
  end;

procedure MCGAINIT;
  begin
    inline ($B8/$13/$00/$CD/$10);
    directvideo:= false;
  end;

begin
  if registerbgidriver (@EGAVGADriver) < 0 then begin end;

end.