unit Chars;

interface

uses
  crt;

Type
   PaletteType   = Array [0..255,1..3] of byte;
   VirtualPal    = PaletteType;

TYPE PaletteEntry=RECORD red,green,blue:BYTE END;
     Palette=ARRAY[0..255] OF PaletteEntry;
     PalettePtr=^Palette;

procedure PrintXY (A, B : integer; Tekst : string);
procedure _TextColor (c : integer);
procedure _TextBackGround (c : integer);
procedure _PutPixel (x, y : integer);
function _GetPixel (x, y : integer) : integer;
procedure BresenhamLine(x1, y1, x2, y2: Integer);
procedure SaveLine (x1, y1, x2,y2 : integer);
procedure RestoreLine;
procedure DrawCircle(xc, yc, r: Integer);
procedure SaveCircle(xc, yc, r: Integer);
procedure RestoreCircle;
(*procedure plot_ellipse(x_center, y_center, a, b : integer);*)
procedure FillCircle (x, y, r : integer);
procedure DrawRectangle (x,y, x2,y2 : integer);
procedure Cls;
PROCEDURE SetPalette(pal:Palette; update:BOOLEAN);
PROCEDURE GetPalette(VAR pal:Palette);
PROCEDURE FadeToPalette(destPal:Palette; AnzSteps:WORD);
procedure ZetPallet (pal : palettetype);

implementation

CONST DefaultColors:Palette=       {Defaultfarben-Palette des 256-Farbmodus}
 (                                 {ausgelesen mithilfe des BIOS-Aufrufs:  }
  (red:  0; green:  0; blue:  0),  { MOV AX,1017h ;lese Palettenregister}
  (red:  0; green:  0; blue: 42),  { XOR BX,BX    ;von Farbe 0 an }
  (red:  0; green: 42; blue:  0),  { MOV CX,100h  ;alle 256 Farben}
  (red:  0; green: 42; blue: 42),  { LES DX,Ziel  ;nach ES:DX }
  (red: 42; green:  0; blue:  0),  { INT 10h }
  (red: 42; green:  0; blue: 42),  {Achtung! Die Werte knn(t)en nur dann  }
  (red: 42; green: 21; blue:  0),  {ausgelesen werden, wenn der Grafikmodus}
  (red: 42; green: 42; blue: 42),  {bereits aktiv ist, deshalb wurden sie  }
  (red: 21; green: 21; blue: 21),  {hier "statisch" aufgenommen!}
  (red: 21; green: 21; blue: 63),
  (red: 21; green: 63; blue: 21),
  (red: 21; green: 63; blue: 63),
  (red: 63; green: 21; blue: 21),
  (red: 63; green: 21; blue: 63),
  (red: 63; green: 63; blue: 21),
  (red: 63; green: 63; blue: 63),
  (red:  0; green:  0; blue:  0),
  (red:  5; green:  5; blue:  5),
  (red:  8; green:  8; blue:  8),
  (red: 11; green: 11; blue: 11),
  (red: 14; green: 14; blue: 14),
  (red: 17; green: 17; blue: 17),
  (red: 20; green: 20; blue: 20),
  (red: 24; green: 24; blue: 24),
  (red: 28; green: 28; blue: 28),
  (red: 32; green: 32; blue: 32),
  (red: 36; green: 36; blue: 36),
  (red: 40; green: 40; blue: 40),
  (red: 45; green: 45; blue: 45),
  (red: 50; green: 50; blue: 50),
  (red: 56; green: 56; blue: 56),
  (red: 63; green: 63; blue: 63),
  (red:  0; green:  0; blue: 63),
  (red: 16; green:  0; blue: 63),
  (red: 31; green:  0; blue: 63),
  (red: 47; green:  0; blue: 63),
  (red: 63; green:  0; blue: 63),
  (red: 63; green:  0; blue: 47),
  (red: 63; green:  0; blue: 31),
  (red: 63; green:  0; blue: 16),
  (red: 63; green:  0; blue:  0),
  (red: 63; green: 16; blue:  0),
  (red: 63; green: 31; blue:  0),
  (red: 63; green: 47; blue:  0),
  (red: 63; green: 63; blue:  0),
  (red: 47; green: 63; blue:  0),
  (red: 31; green: 63; blue:  0),
  (red: 16; green: 63; blue:  0),
  (red:  0; green: 63; blue:  0),
  (red:  0; green: 63; blue: 16),
  (red:  0; green: 63; blue: 31),
  (red:  0; green: 63; blue: 47),
  (red:  0; green: 63; blue: 63),
  (red:  0; green: 47; blue: 63),
  (red:  0; green: 31; blue: 63),
  (red:  0; green: 16; blue: 63),
  (red: 31; green: 31; blue: 63),
  (red: 39; green: 31; blue: 63),
  (red: 47; green: 31; blue: 63),
  (red: 55; green: 31; blue: 63),
  (red: 63; green: 31; blue: 63),
  (red: 63; green: 31; blue: 55),
  (red: 63; green: 31; blue: 47),
  (red: 63; green: 31; blue: 39),
  (red: 63; green: 31; blue: 31),
  (red: 63; green: 39; blue: 31),
  (red: 63; green: 47; blue: 31),
  (red: 63; green: 55; blue: 31),
  (red: 63; green: 63; blue: 31),
  (red: 55; green: 63; blue: 31),
  (red: 47; green: 63; blue: 31),
  (red: 39; green: 63; blue: 31),
  (red: 31; green: 63; blue: 31),
  (red: 31; green: 63; blue: 39),
  (red: 31; green: 63; blue: 47),
  (red: 31; green: 63; blue: 55),
  (red: 31; green: 63; blue: 63),
  (red: 31; green: 55; blue: 63),
  (red: 31; green: 47; blue: 63),
  (red: 31; green: 39; blue: 63),
  (red: 45; green: 45; blue: 63),
  (red: 49; green: 45; blue: 63),
  (red: 54; green: 45; blue: 63),
  (red: 58; green: 45; blue: 63),
  (red: 63; green: 45; blue: 63),
  (red: 63; green: 45; blue: 58),
  (red: 63; green: 45; blue: 54),
  (red: 63; green: 45; blue: 49),
  (red: 63; green: 45; blue: 45),
  (red: 63; green: 49; blue: 45),
  (red: 63; green: 54; blue: 45),
  (red: 63; green: 58; blue: 45),
  (red: 63; green: 63; blue: 45),
  (red: 58; green: 63; blue: 45),
  (red: 54; green: 63; blue: 45),
  (red: 49; green: 63; blue: 45),
  (red: 45; green: 63; blue: 45),
  (red: 45; green: 63; blue: 49),
  (red: 45; green: 63; blue: 54),
  (red: 45; green: 63; blue: 58),
  (red: 45; green: 63; blue: 63),
  (red: 45; green: 58; blue: 63),
  (red: 45; green: 54; blue: 63),
  (red: 45; green: 49; blue: 63),
  (red:  0; green:  0; blue: 28),
  (red:  7; green:  0; blue: 28),
  (red: 14; green:  0; blue: 28),
  (red: 21; green:  0; blue: 28),
  (red: 28; green:  0; blue: 28),
  (red: 28; green:  0; blue: 21),
  (red: 28; green:  0; blue: 14),
  (red: 28; green:  0; blue:  7),
  (red: 28; green:  0; blue:  0),
  (red: 28; green:  7; blue:  0),
  (red: 28; green: 14; blue:  0),
  (red: 28; green: 21; blue:  0),
  (red: 28; green: 28; blue:  0),
  (red: 21; green: 28; blue:  0),
  (red: 14; green: 28; blue:  0),
  (red:  7; green: 28; blue:  0),
  (red:  0; green: 28; blue:  0),
  (red:  0; green: 28; blue:  7),
  (red:  0; green: 28; blue: 14),
  (red:  0; green: 28; blue: 21),
  (red:  0; green: 28; blue: 28),
  (red:  0; green: 21; blue: 28),
  (red:  0; green: 14; blue: 28),
  (red:  0; green:  7; blue: 28),
  (red: 14; green: 14; blue: 28),
  (red: 17; green: 14; blue: 28),
  (red: 21; green: 14; blue: 28),
  (red: 24; green: 14; blue: 28),
  (red: 28; green: 14; blue: 28),
  (red: 28; green: 14; blue: 24),
  (red: 28; green: 14; blue: 21),
  (red: 28; green: 14; blue: 17),
  (red: 28; green: 14; blue: 14),
  (red: 28; green: 17; blue: 14),
  (red: 28; green: 21; blue: 14),
  (red: 28; green: 24; blue: 14),
  (red: 28; green: 28; blue: 14),
  (red: 24; green: 28; blue: 14),
  (red: 21; green: 28; blue: 14),
  (red: 17; green: 28; blue: 14),
  (red: 14; green: 28; blue: 14),
  (red: 14; green: 28; blue: 17),
  (red: 14; green: 28; blue: 21),
  (red: 14; green: 28; blue: 24),
  (red: 14; green: 28; blue: 28),
  (red: 14; green: 24; blue: 28),
  (red: 14; green: 21; blue: 28),
  (red: 14; green: 17; blue: 28),
  (red: 20; green: 20; blue: 28),
  (red: 22; green: 20; blue: 28),
  (red: 24; green: 20; blue: 28),
  (red: 26; green: 20; blue: 28),
  (red: 28; green: 20; blue: 28),
  (red: 28; green: 20; blue: 26),
  (red: 28; green: 20; blue: 24),
  (red: 28; green: 20; blue: 22),
  (red: 28; green: 20; blue: 20),
  (red: 28; green: 22; blue: 20),
  (red: 28; green: 24; blue: 20),
  (red: 28; green: 26; blue: 20),
  (red: 28; green: 28; blue: 20),
  (red: 26; green: 28; blue: 20),
  (red: 24; green: 28; blue: 20),
  (red: 22; green: 28; blue: 20),
  (red: 20; green: 28; blue: 20),
  (red: 20; green: 28; blue: 22),
  (red: 20; green: 28; blue: 24),
  (red: 20; green: 28; blue: 26),
  (red: 20; green: 28; blue: 28),
  (red: 20; green: 26; blue: 28),
  (red: 20; green: 24; blue: 28),
  (red: 20; green: 22; blue: 28),
  (red:  0; green:  0; blue: 16),
  (red:  4; green:  0; blue: 16),
  (red:  8; green:  0; blue: 16),
  (red: 12; green:  0; blue: 16),
  (red: 16; green:  0; blue: 16),
  (red: 16; green:  0; blue: 12),
  (red: 16; green:  0; blue:  8),
  (red: 16; green:  0; blue:  4),
  (red: 16; green:  0; blue:  0),
  (red: 16; green:  4; blue:  0),
  (red: 16; green:  8; blue:  0),
  (red: 16; green: 12; blue:  0),
  (red: 16; green: 16; blue:  0),
  (red: 12; green: 16; blue:  0),
  (red:  8; green: 16; blue:  0),
  (red:  4; green: 16; blue:  0),
  (red:  0; green: 16; blue:  0),
  (red:  0; green: 16; blue:  4),
  (red:  0; green: 16; blue:  8),
  (red:  0; green: 16; blue: 12),
  (red:  0; green: 16; blue: 16),
  (red:  0; green: 12; blue: 16),
  (red:  0; green:  8; blue: 16),
  (red:  0; green:  4; blue: 16),
  (red:  8; green:  8; blue: 16),
  (red: 10; green:  8; blue: 16),
  (red: 12; green:  8; blue: 16),
  (red: 14; green:  8; blue: 16),
  (red: 16; green:  8; blue: 16),
  (red: 16; green:  8; blue: 14),
  (red: 16; green:  8; blue: 12),
  (red: 16; green:  8; blue: 10),
  (red: 16; green:  8; blue:  8),
  (red: 16; green: 10; blue:  8),
  (red: 16; green: 12; blue:  8),
  (red: 16; green: 14; blue:  8),
  (red: 16; green: 16; blue:  8),
  (red: 14; green: 16; blue:  8),
  (red: 12; green: 16; blue:  8),
  (red: 10; green: 16; blue:  8),
  (red:  8; green: 16; blue:  8),
  (red:  8; green: 16; blue: 10),
  (red:  8; green: 16; blue: 12),
  (red:  8; green: 16; blue: 14),
  (red:  8; green: 16; blue: 16),
  (red:  8; green: 14; blue: 16),
  (red:  8; green: 12; blue: 16),
  (red:  8; green: 10; blue: 16),
  (red: 11; green: 11; blue: 16),
  (red: 12; green: 11; blue: 16),
  (red: 13; green: 11; blue: 16),
  (red: 15; green: 11; blue: 16),
  (red: 16; green: 11; blue: 16),
  (red: 16; green: 11; blue: 15),
  (red: 16; green: 11; blue: 13),
  (red: 16; green: 11; blue: 12),
  (red: 16; green: 11; blue: 11),
  (red: 16; green: 12; blue: 11),
  (red: 16; green: 13; blue: 11),
  (red: 16; green: 15; blue: 11),
  (red: 16; green: 16; blue: 11),
  (red: 15; green: 16; blue: 11),
  (red: 13; green: 16; blue: 11),
  (red: 12; green: 16; blue: 11),
  (red: 11; green: 16; blue: 11),
  (red: 11; green: 16; blue: 12),
  (red: 11; green: 16; blue: 13),
  (red: 11; green: 16; blue: 15),
  (red: 11; green: 16; blue: 16),
  (red: 11; green: 15; blue: 16),
  (red: 11; green: 13; blue: 16),
  (red: 11; green: 12; blue: 16),
  (red:  0; green:  0; blue:  0),
  (red:  0; green:  0; blue:  0),
  (red:  0; green:  0; blue:  0),
  (red:  0; green:  0; blue:  0),
  (red:  0; green:  0; blue:  0),
  (red:  0; green:  0; blue:  0),
  (red:  0; green:  0; blue:  0),
  (red:  0; green:  0; blue:  0)
 );

var
  _Ink, _Paper : integer;
  ActualColors : Palette;
  CRTAddress, StatusReg : WORD;

const
  AChar : array[0..255,0..7,0..7] of byte =
(
((0, 0, 0, 0, 0, 0, 0, 0),
(0, 0, 0, 0, 0, 0, 0, 0),
(0, 0, 0, 0, 0, 0, 0, 0),
(0, 0, 0, 0, 0, 0, 0, 0),
(0, 0, 0, 0, 0, 0, 0, 0),
(0, 0, 0, 0, 0, 0, 0, 0),
(0, 0, 0, 0, 0, 0, 0, 0),
(0, 0, 0, 0, 0, 0, 0, 0)
),
((0, 1, 1, 1, 1, 1, 1, 0),
(1, 0, 0, 0, 0, 0, 0, 1), 
(1, 0, 1, 0, 1, 0, 0, 1), 
(1, 0, 0, 0, 1, 1, 0, 1), 
(1, 0, 0, 0, 1, 1, 0, 1), 
(1, 0, 1, 0, 1, 0, 0, 1), 
(1, 0, 0, 0, 0, 0, 0, 1), 
(0, 1, 1, 1, 1, 1, 1, 0)
), 
((0, 1, 1, 1, 1, 1, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(1, 1, 0, 1, 0, 1, 1, 1), 
(1, 1, 1, 1, 0, 0, 1, 1), 
(1, 1, 1, 1, 0, 0, 1, 1), 
(1, 1, 0, 1, 0, 1, 1, 1), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(0, 1, 1, 1, 1, 1, 1, 0)
), 
((0, 1, 1, 1, 0, 0, 0, 0), 
(1, 1, 1, 1, 1, 0, 0, 0), 
(1, 1, 1, 1, 1, 1, 0, 0), 
(0, 1, 1, 1, 1, 1, 1, 0), 
(1, 1, 1, 1, 1, 1, 0, 0), 
(1, 1, 1, 1, 1, 0, 0, 0), 
(0, 1, 1, 1, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 1, 0, 0, 0, 0), 
(0, 0, 1, 1, 1, 0, 0, 0), 
(0, 1, 1, 1, 1, 1, 0, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(0, 1, 1, 1, 1, 1, 0, 0), 
(0, 0, 1, 1, 1, 0, 0, 0), 
(0, 0, 0, 1, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 1, 1, 0, 0, 0), 
(0, 1, 0, 1, 1, 1, 0, 1), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(0, 1, 0, 1, 1, 1, 0, 1), 
(0, 0, 0, 1, 1, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 1, 1, 1, 0, 1), 
(0, 0, 1, 1, 1, 1, 1, 1), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(0, 0, 1, 1, 1, 1, 1, 1), 
(0, 0, 0, 1, 1, 1, 0, 1), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 1, 1, 1, 1, 0, 0), 
(0, 1, 1, 0, 0, 1, 1, 0), 
(0, 1, 0, 0, 0, 0, 1, 0), 
(0, 1, 0, 0, 0, 0, 1, 0), 
(0, 1, 1, 0, 0, 1, 1, 0), 
(0, 0, 1, 1, 1, 1, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 1, 1, 1, 0), 
(0, 0, 0, 1, 1, 1, 1, 1), 
(0, 0, 0, 1, 0, 0, 0, 1), 
(0, 0, 0, 1, 0, 0, 0, 1), 
(1, 0, 1, 1, 1, 1, 1, 1), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 1, 1, 0, 0, 0, 0, 0), 
(1, 1, 1, 1, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(0, 1, 1, 1, 0, 0, 1, 0), 
(1, 1, 1, 1, 1, 0, 1, 0), 
(1, 0, 0, 0, 1, 1, 1, 1), 
(1, 0, 0, 0, 1, 1, 1, 1), 
(1, 1, 1, 1, 1, 0, 1, 0), 
(0, 1, 1, 1, 0, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 1, 1), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 0, 1, 0, 0, 0, 0, 0), 
(1, 0, 1, 0, 0, 0, 0, 0), 
(1, 0, 1, 0, 0, 1, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 1, 1, 1, 1, 1, 0, 0)
), 
((1, 0, 0, 1, 1, 0, 0, 1), 
(0, 1, 0, 1, 1, 0, 1, 0), 
(0, 0, 1, 1, 1, 1, 0, 0), 
(1, 1, 1, 0, 0, 1, 1, 1), 
(1, 1, 1, 0, 0, 1, 1, 1), 
(0, 0, 1, 1, 1, 1, 0, 0), 
(0, 1, 0, 1, 1, 0, 1, 0), 
(1, 0, 0, 1, 1, 0, 0, 1)
), 
((1, 1, 1, 1, 1, 1, 1, 0), 
(0, 1, 1, 1, 1, 1, 0, 0), 
(0, 1, 1, 1, 1, 1, 0, 0), 
(0, 0, 1, 1, 1, 0, 0, 0), 
(0, 0, 1, 1, 1, 0, 0, 0), 
(0, 0, 0, 1, 0, 0, 0, 0), 
(0, 0, 0, 1, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 1, 0, 0, 0, 0), 
(0, 0, 0, 1, 0, 0, 0, 0), 
(0, 0, 1, 1, 1, 0, 0, 0), 
(0, 0, 1, 1, 1, 0, 0, 0), 
(0, 1, 1, 1, 1, 1, 0, 0), 
(0, 1, 1, 1, 1, 1, 0, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 1, 0, 0, 1, 0, 0), 
(0, 1, 1, 0, 0, 1, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(0, 1, 1, 0, 0, 1, 1, 0), 
(0, 0, 1, 0, 0, 1, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(1, 1, 1, 1, 1, 0, 1, 0), 
(1, 1, 1, 1, 1, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(1, 1, 1, 1, 1, 0, 1, 0), 
(1, 1, 1, 1, 1, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 1, 1, 0, 0, 0, 0, 0), 
(1, 1, 1, 1, 0, 0, 0, 0), 
(1, 0, 0, 1, 0, 0, 0, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 0, 0, 0, 0, 0, 0, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0)
), 
((0, 0, 0, 0, 0, 0, 1, 0), 
(0, 1, 0, 1, 1, 0, 1, 1), 
(1, 1, 1, 1, 1, 1, 0, 1), 
(1, 0, 1, 0, 0, 1, 0, 1), 
(1, 0, 1, 1, 1, 1, 1, 1), 
(1, 0, 0, 1, 1, 0, 1, 0), 
(1, 1, 0, 0, 0, 0, 0, 0), 
(0, 1, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 1, 1, 1, 0), 
(0, 0, 0, 0, 1, 1, 1, 0), 
(0, 0, 0, 0, 1, 1, 1, 0), 
(0, 0, 0, 0, 1, 1, 1, 0), 
(0, 0, 0, 0, 1, 1, 1, 0), 
(0, 0, 0, 0, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 1), 
(0, 0, 1, 0, 1, 0, 0, 1), 
(0, 1, 1, 0, 1, 1, 0, 1), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(0, 1, 1, 0, 1, 1, 0, 1), 
(0, 0, 1, 0, 1, 0, 0, 1), 
(0, 0, 0, 0, 0, 0, 0, 1)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 1, 0, 0, 0, 0, 0), 
(0, 1, 1, 0, 0, 0, 0, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(0, 1, 1, 0, 0, 0, 0, 0), 
(0, 0, 1, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 1, 0, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 1, 1, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 1, 0, 0, 0, 0), 
(0, 0, 0, 1, 0, 0, 0, 0), 
(0, 0, 0, 1, 0, 0, 0, 0), 
(0, 1, 0, 1, 0, 1, 0, 0), 
(0, 1, 1, 1, 1, 1, 0, 0), 
(0, 0, 1, 1, 1, 0, 0, 0), 
(0, 0, 0, 1, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 1, 0, 0, 0, 0), 
(0, 0, 1, 1, 1, 0, 0, 0), 
(0, 1, 1, 1, 1, 1, 0, 0), 
(0, 1, 0, 1, 0, 1, 0, 0), 
(0, 0, 0, 1, 0, 0, 0, 0), 
(0, 0, 0, 1, 0, 0, 0, 0), 
(0, 0, 0, 1, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 1, 1, 1, 1, 0, 0), 
(0, 0, 1, 1, 1, 1, 0, 0), 
(0, 0, 0, 0, 0, 1, 0, 0), 
(0, 0, 0, 0, 0, 1, 0, 0), 
(0, 0, 0, 0, 0, 1, 0, 0), 
(0, 0, 0, 0, 0, 1, 0, 0), 
(0, 0, 0, 0, 0, 1, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 1, 0, 0, 0, 0), 
(0, 0, 1, 1, 1, 0, 0, 0), 
(0, 1, 1, 1, 1, 1, 0, 0), 
(0, 0, 0, 1, 0, 0, 0, 0), 
(0, 0, 0, 1, 0, 0, 0, 0), 
(0, 1, 1, 1, 1, 1, 0, 0), 
(0, 0, 1, 1, 1, 0, 0, 0), 
(0, 0, 0, 1, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 1, 1, 0, 0), 
(0, 0, 0, 1, 1, 1, 0, 0), 
(0, 0, 1, 1, 1, 1, 0, 0), 
(0, 1, 1, 1, 1, 1, 0, 0), 
(0, 1, 1, 1, 1, 1, 0, 0), 
(0, 0, 1, 1, 1, 1, 0, 0), 
(0, 0, 0, 1, 1, 1, 0, 0), 
(0, 0, 0, 0, 1, 1, 0, 0)
), 
((0, 1, 1, 0, 0, 0, 0, 0), 
(0, 1, 1, 1, 0, 0, 0, 0), 
(0, 1, 1, 1, 1, 0, 0, 0), 
(0, 1, 1, 1, 1, 1, 0, 0), 
(0, 1, 1, 1, 1, 1, 0, 0), 
(0, 1, 1, 1, 1, 0, 0, 0), 
(0, 1, 1, 1, 0, 0, 0, 0), 
(0, 1, 1, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(0, 1, 1, 0, 0, 0, 0, 0), 
(1, 1, 1, 1, 1, 0, 1, 0), 
(1, 1, 1, 1, 1, 0, 1, 0), 
(0, 1, 1, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(1, 1, 1, 0, 0, 0, 0, 0), 
(1, 1, 1, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(1, 1, 1, 0, 0, 0, 0, 0), 
(1, 1, 1, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 1, 0, 1, 0, 0, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(0, 0, 1, 0, 1, 0, 0, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(0, 0, 1, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 1, 0, 0, 1, 0, 0), 
(0, 1, 1, 1, 0, 1, 0, 0), 
(1, 1, 0, 1, 0, 1, 1, 0), 
(1, 1, 0, 1, 0, 1, 1, 0), 
(0, 1, 0, 1, 1, 1, 0, 0), 
(0, 1, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 1, 1, 0, 0, 0, 1, 0), 
(0, 1, 1, 0, 0, 1, 1, 0), 
(0, 0, 0, 0, 1, 1, 0, 0), 
(0, 0, 0, 1, 1, 0, 0, 0), 
(0, 0, 1, 1, 0, 0, 0, 0), 
(0, 1, 1, 0, 0, 1, 1, 0), 
(0, 1, 0, 0, 0, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 1, 1, 0, 0), 
(0, 1, 0, 1, 1, 1, 1, 0), 
(1, 1, 1, 1, 0, 0, 1, 0), 
(1, 0, 1, 1, 1, 0, 1, 0), 
(1, 1, 1, 0, 1, 1, 0, 0), 
(0, 1, 0, 1, 1, 1, 1, 0), 
(0, 0, 0, 1, 0, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 1, 0, 0, 0, 0, 0), 
(1, 1, 1, 0, 0, 0, 0, 0), 
(1, 1, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 1, 1, 1, 0, 0, 0), 
(0, 1, 1, 1, 1, 1, 0, 0), 
(1, 1, 0, 0, 0, 1, 1, 0), 
(1, 0, 0, 0, 0, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(1, 0, 0, 0, 0, 0, 1, 0), 
(1, 1, 0, 0, 0, 1, 1, 0), 
(0, 1, 1, 1, 1, 1, 0, 0), 
(0, 0, 1, 1, 1, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 1, 0, 0, 0, 0), 
(0, 1, 0, 1, 0, 1, 0, 0), 
(0, 1, 1, 1, 1, 1, 0, 0), 
(0, 0, 1, 1, 1, 0, 0, 0), 
(0, 0, 1, 1, 1, 0, 0, 0), 
(0, 1, 1, 1, 1, 1, 0, 0), 
(0, 1, 0, 1, 0, 1, 0, 0), 
(0, 0, 0, 1, 0, 0, 0, 0)
), 
((0, 0, 0, 1, 0, 0, 0, 0), 
(0, 0, 0, 1, 0, 0, 0, 0), 
(0, 1, 1, 1, 1, 1, 0, 0), 
(0, 1, 1, 1, 1, 1, 0, 0), 
(0, 0, 0, 1, 0, 0, 0, 0), 
(0, 0, 0, 1, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 1), 
(0, 0, 0, 0, 0, 1, 1, 1), 
(0, 0, 0, 0, 0, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 1, 0, 0, 0, 0), 
(0, 0, 0, 1, 0, 0, 0, 0), 
(0, 0, 0, 1, 0, 0, 0, 0), 
(0, 0, 0, 1, 0, 0, 0, 0), 
(0, 0, 0, 1, 0, 0, 0, 0), 
(0, 0, 0, 1, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 1, 1, 0), 
(0, 0, 0, 0, 0, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 1, 1, 0), 
(0, 0, 0, 0, 1, 1, 0, 0), 
(0, 0, 0, 1, 1, 0, 0, 0), 
(0, 0, 1, 1, 0, 0, 0, 0), 
(0, 1, 1, 0, 0, 0, 0, 0), 
(1, 1, 0, 0, 0, 0, 0, 0), 
(1, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 1, 1, 1, 1, 1, 0, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 0, 0, 0, 1, 1, 1, 0), 
(1, 0, 0, 1, 1, 0, 1, 0), 
(1, 0, 1, 1, 0, 0, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(0, 1, 1, 1, 1, 1, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 1, 0), 
(0, 1, 0, 0, 0, 0, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 1, 0, 0, 0, 1, 1, 0), 
(1, 1, 0, 0, 1, 1, 1, 0), 
(1, 0, 0, 1, 1, 0, 1, 0), 
(1, 0, 0, 1, 0, 0, 1, 0), 
(1, 1, 1, 1, 0, 1, 1, 0), 
(0, 1, 1, 0, 0, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 1, 0, 0, 0, 1, 0, 0), 
(1, 1, 0, 0, 0, 1, 1, 0), 
(1, 0, 0, 1, 0, 0, 1, 0), 
(1, 0, 0, 1, 0, 0, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(0, 1, 1, 0, 1, 1, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 1, 1, 0, 0, 0), 
(0, 0, 1, 1, 1, 0, 0, 0), 
(0, 1, 1, 0, 1, 0, 0, 0), 
(1, 1, 0, 0, 1, 0, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 1, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((1, 1, 1, 0, 0, 1, 0, 0), 
(1, 1, 1, 0, 0, 1, 1, 0), 
(1, 0, 1, 0, 0, 0, 1, 0), 
(1, 0, 1, 0, 0, 0, 1, 0), 
(1, 0, 1, 1, 1, 1, 1, 0), 
(1, 0, 0, 1, 1, 1, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 1, 1, 1, 1, 0, 0), 
(0, 1, 1, 1, 1, 1, 1, 0), 
(1, 1, 0, 1, 0, 0, 1, 0), 
(1, 0, 0, 1, 0, 0, 1, 0), 
(1, 0, 0, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 1, 1, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((1, 1, 0, 0, 0, 0, 0, 0), 
(1, 1, 0, 0, 0, 0, 0, 0), 
(1, 0, 0, 0, 1, 1, 1, 0), 
(1, 0, 0, 1, 1, 1, 1, 0), 
(1, 1, 1, 1, 0, 0, 0, 0), 
(1, 1, 1, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 1, 1, 0, 1, 1, 0, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 0, 0, 1, 0, 0, 1, 0), 
(1, 0, 0, 1, 0, 0, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(0, 1, 1, 0, 1, 1, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 1, 1, 0, 0, 0, 0, 0), 
(1, 1, 1, 1, 0, 0, 1, 0), 
(1, 0, 0, 1, 0, 0, 1, 0), 
(1, 0, 0, 1, 0, 1, 1, 0), 
(1, 1, 1, 1, 1, 1, 0, 0), 
(0, 1, 1, 1, 1, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 1, 1, 0, 0, 1, 1, 0), 
(0, 1, 1, 0, 0, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 1), 
(0, 1, 1, 0, 0, 1, 1, 1), 
(0, 1, 1, 0, 0, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 1, 0, 0, 0, 0), 
(0, 0, 1, 1, 1, 0, 0, 0), 
(0, 1, 1, 0, 1, 1, 0, 0), 
(1, 1, 0, 0, 0, 1, 1, 0), 
(1, 0, 0, 0, 0, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 1, 0, 0, 1, 0, 0), 
(0, 0, 1, 0, 0, 1, 0, 0), 
(0, 0, 1, 0, 0, 1, 0, 0), 
(0, 0, 1, 0, 0, 1, 0, 0), 
(0, 0, 1, 0, 0, 1, 0, 0), 
(0, 0, 1, 0, 0, 1, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(1, 0, 0, 0, 0, 0, 1, 0), 
(1, 1, 0, 0, 0, 1, 1, 0), 
(0, 1, 1, 0, 1, 1, 0, 0), 
(0, 0, 1, 1, 1, 0, 0, 0), 
(0, 0, 0, 1, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 1, 0, 0, 0, 0, 0, 0), 
(1, 1, 0, 0, 0, 0, 0, 0), 
(1, 0, 0, 0, 1, 0, 1, 0), 
(1, 0, 0, 1, 1, 0, 1, 0), 
(1, 1, 1, 1, 0, 0, 0, 0), 
(0, 1, 1, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 1, 1, 1, 1, 1, 0, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 0, 0, 0, 0, 0, 1, 0), 
(1, 0, 1, 1, 1, 0, 1, 0), 
(1, 0, 1, 1, 1, 0, 1, 0), 
(1, 1, 1, 1, 1, 0, 0, 0), 
(0, 1, 1, 1, 1, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 1, 1, 1, 1, 1, 0), 
(0, 1, 1, 1, 1, 1, 1, 0), 
(1, 1, 0, 0, 1, 0, 0, 0), 
(1, 1, 0, 0, 1, 0, 0, 0), 
(0, 1, 1, 1, 1, 1, 1, 0), 
(0, 0, 1, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((1, 0, 0, 0, 0, 0, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 0, 0, 1, 0, 0, 1, 0), 
(1, 0, 0, 1, 0, 0, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(0, 1, 1, 0, 1, 1, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 1, 1, 1, 0, 0, 0), 
(0, 1, 1, 1, 1, 1, 0, 0), 
(1, 1, 0, 0, 0, 1, 1, 0), 
(1, 0, 0, 0, 0, 0, 1, 0), 
(1, 0, 0, 0, 0, 0, 1, 0), 
(1, 1, 0, 0, 0, 1, 1, 0), 
(0, 1, 0, 0, 0, 1, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((1, 0, 0, 0, 0, 0, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 0, 0, 0, 0, 0, 1, 0), 
(1, 1, 0, 0, 0, 1, 1, 0), 
(0, 1, 1, 1, 1, 1, 0, 0), 
(0, 0, 1, 1, 1, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((1, 0, 0, 0, 0, 0, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 0, 0, 1, 0, 0, 1, 0), 
(1, 0, 1, 1, 1, 0, 1, 0), 
(1, 0, 0, 0, 0, 0, 1, 0), 
(1, 1, 0, 0, 0, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((1, 0, 0, 0, 0, 0, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 0, 0, 1, 0, 0, 1, 0), 
(1, 0, 1, 1, 1, 0, 0, 0), 
(1, 0, 0, 0, 0, 0, 0, 0), 
(1, 1, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 1, 1, 1, 0, 0, 0), 
(0, 1, 1, 1, 1, 1, 0, 0), 
(1, 1, 0, 0, 0, 1, 1, 0), 
(1, 0, 0, 0, 0, 0, 1, 0), 
(1, 0, 0, 0, 1, 0, 1, 0), 
(1, 1, 0, 0, 1, 1, 1, 0), 
(0, 1, 0, 0, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((1, 1, 1, 1, 1, 1, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(0, 0, 0, 1, 0, 0, 0, 0), 
(0, 0, 0, 1, 0, 0, 0, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(1, 0, 0, 0, 0, 0, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 0, 0, 0, 0, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 1, 1, 0, 0), 
(0, 0, 0, 0, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 1, 0), 
(1, 0, 0, 0, 0, 0, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 1, 1, 1, 1, 1, 0, 0), 
(1, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((1, 0, 0, 0, 0, 0, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(0, 0, 0, 1, 0, 0, 0, 0), 
(0, 0, 1, 1, 1, 0, 0, 0), 
(1, 1, 1, 0, 1, 1, 1, 0), 
(1, 1, 0, 0, 0, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((1, 0, 0, 0, 0, 0, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 0, 0, 0, 0, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 1, 0), 
(0, 0, 0, 0, 0, 1, 1, 0), 
(0, 0, 0, 0, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((1, 1, 1, 1, 1, 1, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(0, 1, 1, 1, 0, 0, 0, 0), 
(0, 0, 1, 1, 1, 0, 0, 0), 
(0, 1, 1, 1, 0, 0, 0, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((1, 1, 1, 1, 1, 1, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(0, 1, 1, 0, 0, 0, 0, 0), 
(0, 0, 1, 1, 0, 0, 0, 0), 
(0, 0, 0, 1, 1, 0, 0, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 1, 1, 1, 0, 0, 0), 
(0, 1, 1, 1, 1, 1, 0, 0), 
(1, 1, 0, 0, 0, 1, 1, 0), 
(1, 0, 0, 0, 0, 0, 1, 0), 
(1, 1, 0, 0, 0, 1, 1, 0), 
(0, 1, 1, 1, 1, 1, 0, 0), 
(0, 0, 1, 1, 1, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((1, 0, 0, 0, 0, 0, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 0, 0, 1, 0, 0, 1, 0), 
(1, 0, 0, 1, 0, 0, 0, 0), 
(1, 1, 1, 1, 0, 0, 0, 0), 
(0, 1, 1, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 1, 1, 1, 1, 0, 0, 0), 
(1, 1, 1, 1, 1, 1, 0, 0), 
(1, 0, 0, 0, 0, 1, 0, 0), 
(1, 0, 0, 0, 1, 1, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(0, 1, 1, 1, 1, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((1, 0, 0, 0, 0, 0, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 0, 0, 1, 0, 0, 0, 0), 
(1, 0, 0, 1, 1, 0, 0, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(0, 1, 1, 0, 0, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 1, 1, 0, 0, 1, 0, 0), 
(1, 1, 1, 1, 0, 1, 1, 0), 
(1, 0, 1, 1, 0, 0, 1, 0), 
(1, 0, 0, 1, 1, 0, 1, 0), 
(1, 1, 0, 0, 1, 1, 1, 0), 
(0, 1, 0, 0, 1, 1, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((1, 1, 0, 0, 0, 0, 0, 0), 
(1, 0, 0, 0, 0, 0, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 0, 0, 0, 0, 0, 1, 0), 
(1, 1, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((1, 1, 1, 1, 1, 1, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((1, 1, 1, 1, 1, 0, 0, 0), 
(1, 1, 1, 1, 1, 1, 0, 0), 
(0, 0, 0, 0, 0, 1, 1, 0), 
(0, 0, 0, 0, 0, 1, 1, 0), 
(1, 1, 1, 1, 1, 1, 0, 0), 
(1, 1, 1, 1, 1, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((1, 1, 1, 1, 1, 1, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 1, 1, 0, 0), 
(0, 0, 0, 1, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 1, 0, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((1, 1, 0, 0, 0, 0, 1, 0), 
(1, 1, 1, 0, 0, 1, 1, 0), 
(0, 0, 1, 1, 1, 1, 0, 0), 
(0, 0, 0, 1, 1, 0, 0, 0), 
(0, 0, 1, 1, 1, 1, 0, 0), 
(1, 1, 1, 0, 0, 1, 1, 0), 
(1, 1, 0, 0, 0, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((1, 1, 1, 0, 0, 0, 0, 0), 
(1, 1, 1, 1, 0, 0, 1, 0), 
(0, 0, 0, 1, 1, 1, 1, 0), 
(0, 0, 0, 1, 1, 1, 1, 0), 
(1, 1, 1, 1, 0, 0, 1, 0), 
(1, 1, 1, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((1, 1, 1, 0, 0, 0, 1, 0), 
(1, 1, 0, 0, 0, 1, 1, 0), 
(1, 0, 0, 0, 1, 1, 1, 0), 
(1, 0, 0, 1, 1, 0, 1, 0), 
(1, 0, 1, 1, 0, 0, 1, 0), 
(1, 1, 1, 0, 0, 1, 1, 0), 
(1, 1, 0, 0, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 0, 0, 0, 0, 0, 1, 0), 
(1, 0, 0, 0, 0, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((1, 0, 0, 0, 0, 0, 0, 0), 
(1, 1, 0, 0, 0, 0, 0, 0), 
(0, 1, 1, 0, 0, 0, 0, 0), 
(0, 0, 1, 1, 0, 0, 0, 0), 
(0, 0, 0, 1, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 1, 0, 0), 
(0, 0, 0, 0, 0, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(1, 0, 0, 0, 0, 0, 1, 0), 
(1, 0, 0, 0, 0, 0, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 1, 0, 0, 0, 0), 
(0, 0, 1, 1, 0, 0, 0, 0), 
(0, 1, 1, 0, 0, 0, 0, 0), 
(1, 1, 0, 0, 0, 0, 0, 0), 
(0, 1, 1, 0, 0, 0, 0, 0), 
(0, 0, 1, 1, 0, 0, 0, 0), 
(0, 0, 0, 1, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 1), 
(0, 0, 0, 0, 0, 0, 0, 1), 
(0, 0, 0, 0, 0, 0, 0, 1), 
(0, 0, 0, 0, 0, 0, 0, 1), 
(0, 0, 0, 0, 0, 0, 0, 1), 
(0, 0, 0, 0, 0, 0, 0, 1), 
(0, 0, 0, 0, 0, 0, 0, 1), 
(0, 0, 0, 0, 0, 0, 0, 1)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(1, 1, 0, 0, 0, 0, 0, 0), 
(1, 1, 1, 0, 0, 0, 0, 0), 
(0, 0, 1, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 1, 0, 0), 
(0, 0, 1, 0, 1, 1, 1, 0), 
(0, 0, 1, 0, 1, 0, 1, 0), 
(0, 0, 1, 0, 1, 0, 1, 0), 
(0, 0, 1, 1, 1, 1, 0, 0), 
(0, 0, 0, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((1, 0, 0, 0, 0, 0, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 1, 1, 1, 1, 1, 0, 0), 
(0, 0, 0, 1, 0, 0, 1, 0), 
(0, 0, 0, 1, 0, 0, 1, 0), 
(0, 0, 0, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 1, 1, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 1, 1, 1, 0, 0), 
(0, 0, 1, 1, 1, 1, 1, 0), 
(0, 0, 1, 0, 0, 0, 1, 0), 
(0, 0, 1, 0, 0, 0, 1, 0), 
(0, 0, 1, 1, 0, 1, 1, 0), 
(0, 0, 0, 1, 0, 1, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 1, 1, 0, 0), 
(0, 0, 0, 1, 1, 1, 1, 0), 
(0, 0, 0, 1, 0, 0, 1, 0), 
(1, 0, 0, 1, 0, 0, 1, 0), 
(1, 1, 1, 1, 1, 1, 0, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 1, 1, 1, 0, 0), 
(0, 0, 1, 1, 1, 1, 1, 0), 
(0, 0, 1, 0, 1, 0, 1, 0), 
(0, 0, 1, 0, 1, 0, 1, 0), 
(0, 0, 1, 1, 1, 0, 1, 0), 
(0, 0, 0, 1, 1, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 1, 0, 0, 1, 0), 
(0, 1, 1, 1, 1, 1, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 0, 0, 1, 0, 0, 1, 0), 
(1, 1, 0, 0, 0, 0, 0, 0), 
(0, 1, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 1, 1, 0, 0, 1), 
(0, 0, 1, 1, 1, 1, 0, 1), 
(0, 0, 1, 0, 0, 1, 0, 1), 
(0, 0, 1, 0, 0, 1, 0, 1), 
(0, 0, 0, 1, 1, 1, 1, 1), 
(0, 0, 1, 1, 1, 1, 1, 0), 
(0, 0, 1, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((1, 0, 0, 0, 0, 0, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(0, 0, 0, 1, 0, 0, 0, 0), 
(0, 0, 1, 0, 0, 0, 0, 0), 
(0, 0, 1, 1, 1, 1, 1, 0), 
(0, 0, 0, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 1, 0, 0, 0, 1, 0), 
(1, 0, 1, 1, 1, 1, 1, 0), 
(1, 0, 1, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 1, 1, 0), 
(0, 0, 0, 0, 0, 1, 1, 1), 
(0, 0, 0, 0, 0, 0, 0, 1), 
(0, 0, 0, 0, 0, 0, 0, 1), 
(1, 0, 1, 1, 1, 1, 1, 1), 
(1, 0, 1, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((1, 0, 0, 0, 0, 0, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 1, 1, 1, 0, 0), 
(0, 0, 1, 1, 0, 1, 1, 0), 
(0, 0, 1, 0, 0, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(1, 0, 0, 0, 0, 0, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 1, 1, 1, 1, 1, 0), 
(0, 0, 1, 1, 1, 1, 1, 0), 
(0, 0, 0, 1, 1, 0, 0, 0), 
(0, 0, 0, 1, 1, 1, 0, 0), 
(0, 0, 1, 1, 1, 0, 0, 0), 
(0, 0, 1, 1, 1, 1, 1, 0), 
(0, 0, 0, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 1, 1, 1, 1, 1, 0), 
(0, 0, 1, 1, 1, 1, 1, 0), 
(0, 0, 1, 0, 0, 0, 0, 0), 
(0, 0, 1, 0, 0, 0, 0, 0), 
(0, 0, 1, 1, 1, 1, 1, 0), 
(0, 0, 0, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 1, 1, 1, 0, 0), 
(0, 0, 1, 1, 1, 1, 1, 0), 
(0, 0, 1, 0, 0, 0, 1, 0), 
(0, 0, 1, 0, 0, 0, 1, 0), 
(0, 0, 1, 1, 1, 1, 1, 0), 
(0, 0, 0, 1, 1, 1, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 1, 0, 0, 0, 0, 1), 
(0, 0, 1, 1, 1, 1, 1, 1), 
(0, 0, 0, 1, 1, 1, 1, 1), 
(0, 0, 1, 0, 0, 1, 0, 1), 
(0, 0, 1, 0, 0, 1, 0, 0), 
(0, 0, 1, 1, 1, 1, 0, 0), 
(0, 0, 0, 1, 1, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 1, 1, 0, 0, 0), 
(0, 0, 1, 1, 1, 1, 0, 0), 
(0, 0, 1, 0, 0, 1, 0, 0), 
(0, 0, 1, 0, 0, 1, 0, 1), 
(0, 0, 0, 1, 1, 1, 1, 1), 
(0, 0, 1, 1, 1, 1, 1, 1), 
(0, 0, 1, 0, 0, 0, 0, 1), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 1, 0, 0, 0, 1, 0), 
(0, 0, 1, 1, 1, 1, 1, 0), 
(0, 0, 0, 1, 1, 1, 1, 0), 
(0, 0, 1, 1, 0, 0, 1, 0), 
(0, 0, 1, 0, 0, 0, 0, 0), 
(0, 0, 1, 1, 1, 0, 0, 0), 
(0, 0, 0, 1, 1, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 1, 0, 0, 1, 0), 
(0, 0, 1, 1, 1, 0, 1, 0), 
(0, 0, 1, 0, 1, 0, 1, 0), 
(0, 0, 1, 0, 1, 0, 1, 0), 
(0, 0, 1, 0, 1, 1, 1, 0), 
(0, 0, 1, 0, 0, 1, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 1, 0, 0, 0, 0, 0), 
(0, 1, 1, 1, 1, 1, 0, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(0, 0, 1, 0, 0, 0, 1, 0), 
(0, 0, 1, 0, 0, 1, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 1, 1, 1, 1, 0, 0), 
(0, 0, 1, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 1, 0), 
(0, 0, 1, 1, 1, 1, 0, 0), 
(0, 0, 1, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 1, 1, 1, 0, 0, 0), 
(0, 0, 1, 1, 1, 1, 0, 0), 
(0, 0, 0, 0, 0, 1, 1, 0), 
(0, 0, 0, 0, 0, 1, 1, 0), 
(0, 0, 1, 1, 1, 1, 0, 0), 
(0, 0, 1, 1, 1, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 1, 1, 1, 1, 0, 0), 
(0, 0, 1, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 1, 1, 1, 0), 
(0, 0, 0, 1, 1, 1, 0, 0), 
(0, 0, 0, 0, 1, 1, 1, 0), 
(0, 0, 1, 1, 1, 1, 1, 0), 
(0, 0, 1, 1, 1, 1, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 1, 0, 0, 0, 1, 0), 
(0, 0, 1, 1, 0, 1, 1, 0), 
(0, 0, 0, 1, 1, 1, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 1, 1, 1, 0, 0), 
(0, 0, 1, 1, 0, 1, 1, 0), 
(0, 0, 1, 0, 0, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 1, 1, 1, 0, 0, 1), 
(0, 0, 1, 1, 1, 1, 0, 1), 
(0, 0, 0, 0, 0, 1, 0, 1), 
(0, 0, 0, 0, 0, 1, 0, 1), 
(0, 0, 1, 1, 1, 1, 1, 1), 
(0, 0, 1, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 1, 1, 0, 0, 1, 0), 
(0, 0, 1, 0, 0, 1, 1, 0), 
(0, 0, 1, 0, 1, 1, 1, 0), 
(0, 0, 1, 1, 1, 0, 1, 0), 
(0, 0, 1, 1, 0, 0, 1, 0), 
(0, 0, 1, 0, 0, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 1, 0, 0, 0, 0), 
(0, 0, 0, 1, 0, 0, 0, 0), 
(0, 1, 1, 1, 1, 1, 0, 0), 
(1, 1, 1, 0, 1, 1, 1, 0), 
(1, 0, 0, 0, 0, 0, 1, 0), 
(1, 0, 0, 0, 0, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(1, 1, 1, 0, 1, 1, 1, 0), 
(1, 1, 1, 0, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((1, 0, 0, 0, 0, 0, 1, 0), 
(1, 0, 0, 0, 0, 0, 1, 0), 
(1, 1, 1, 0, 1, 1, 1, 0), 
(0, 1, 1, 1, 1, 1, 0, 0), 
(0, 0, 0, 1, 0, 0, 0, 0), 
(0, 0, 0, 1, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 1, 0, 0, 0, 0, 0, 0), 
(1, 1, 0, 0, 0, 0, 0, 0), 
(1, 0, 0, 0, 0, 0, 0, 0), 
(1, 1, 0, 0, 0, 0, 0, 0), 
(0, 1, 0, 0, 0, 0, 0, 0), 
(1, 1, 0, 0, 0, 0, 0, 0), 
(1, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 1, 1, 1, 0), 
(0, 0, 0, 1, 1, 1, 1, 0), 
(0, 0, 1, 1, 0, 0, 1, 0), 
(0, 1, 1, 0, 0, 0, 1, 0), 
(0, 0, 1, 1, 0, 0, 1, 0), 
(0, 0, 0, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 1, 1, 1, 0, 0, 0, 0), 
(1, 1, 1, 1, 1, 0, 0, 1), 
(1, 0, 0, 0, 1, 0, 0, 1), 
(1, 0, 0, 0, 1, 1, 0, 1), 
(1, 1, 0, 1, 1, 1, 1, 1), 
(0, 1, 0, 1, 0, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 1, 0, 1, 1, 1, 0, 0), 
(0, 1, 0, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 1, 0), 
(0, 1, 0, 1, 1, 1, 1, 0), 
(0, 1, 0, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 1, 1, 1, 0, 0), 
(0, 0, 1, 1, 1, 1, 1, 0), 
(0, 0, 1, 0, 1, 0, 1, 0), 
(1, 0, 1, 0, 1, 0, 1, 0), 
(1, 0, 1, 1, 1, 0, 1, 0), 
(1, 0, 0, 1, 1, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 1, 0, 0, 0, 0, 0, 0), 
(1, 1, 0, 0, 0, 1, 0, 0), 
(1, 0, 1, 0, 1, 1, 1, 0), 
(1, 0, 1, 0, 1, 0, 1, 0), 
(1, 0, 1, 0, 1, 0, 1, 0), 
(1, 0, 1, 1, 1, 1, 1, 0), 
(1, 1, 0, 1, 1, 1, 1, 0), 
(0, 1, 0, 0, 0, 0, 1, 0)
), 
((1, 0, 0, 0, 0, 1, 0, 0), 
(1, 0, 1, 0, 1, 1, 1, 0), 
(0, 0, 1, 0, 1, 0, 1, 0), 
(0, 0, 1, 0, 1, 0, 1, 0), 
(1, 0, 1, 1, 1, 1, 1, 0), 
(1, 0, 0, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((1, 0, 0, 0, 0, 1, 0, 0), 
(1, 0, 1, 0, 1, 1, 1, 0), 
(1, 0, 1, 0, 1, 0, 1, 0), 
(0, 0, 1, 0, 1, 0, 1, 0), 
(0, 0, 1, 1, 1, 1, 1, 0), 
(0, 0, 0, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 1, 0, 0), 
(0, 0, 1, 0, 1, 1, 1, 0), 
(1, 1, 1, 0, 1, 0, 1, 0), 
(1, 1, 1, 0, 1, 0, 1, 0), 
(0, 0, 1, 1, 1, 1, 1, 0), 
(0, 0, 0, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 1, 1, 0, 0, 0), 
(0, 0, 1, 1, 1, 1, 0, 0), 
(0, 0, 1, 0, 0, 1, 0, 1), 
(0, 0, 1, 0, 0, 1, 0, 1), 
(0, 0, 1, 0, 0, 1, 1, 1), 
(0, 0, 0, 0, 0, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 1, 0, 0, 0, 0, 0, 0), 
(1, 1, 0, 1, 1, 1, 0, 0), 
(1, 0, 1, 1, 1, 1, 1, 0), 
(1, 0, 1, 0, 1, 0, 1, 0), 
(1, 0, 1, 0, 1, 0, 1, 0), 
(1, 0, 1, 1, 1, 0, 1, 0), 
(1, 1, 0, 1, 1, 0, 0, 0), 
(0, 1, 0, 0, 0, 0, 0, 0)
), 
((1, 0, 0, 1, 1, 1, 0, 0), 
(1, 0, 1, 1, 1, 1, 1, 0), 
(0, 0, 1, 0, 1, 0, 1, 0), 
(0, 0, 1, 0, 1, 0, 1, 0), 
(1, 0, 1, 1, 1, 0, 1, 0), 
(1, 0, 0, 1, 1, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((1, 0, 0, 1, 1, 1, 0, 0), 
(1, 0, 1, 1, 1, 1, 1, 0), 
(1, 0, 1, 0, 1, 0, 1, 0), 
(0, 0, 1, 0, 1, 0, 1, 0), 
(0, 0, 1, 1, 1, 0, 1, 0), 
(0, 0, 0, 1, 1, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((1, 0, 0, 0, 0, 0, 0, 0), 
(1, 0, 1, 0, 0, 0, 1, 0), 
(0, 0, 1, 1, 1, 1, 1, 0), 
(0, 0, 1, 1, 1, 1, 1, 0), 
(1, 0, 0, 0, 0, 0, 1, 0), 
(1, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 1, 0, 0, 0, 0, 0, 0), 
(1, 1, 0, 0, 0, 0, 0, 0), 
(1, 0, 1, 0, 0, 0, 1, 0), 
(1, 0, 1, 1, 1, 1, 1, 0), 
(1, 0, 1, 1, 1, 1, 1, 0), 
(1, 1, 0, 0, 0, 0, 1, 0), 
(0, 1, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((1, 0, 0, 0, 0, 0, 0, 0), 
(1, 0, 1, 0, 0, 0, 1, 0), 
(1, 0, 1, 1, 1, 1, 1, 0), 
(0, 0, 1, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((1, 0, 0, 1, 1, 1, 1, 0), 
(1, 0, 1, 1, 1, 1, 1, 0), 
(0, 1, 1, 0, 1, 0, 0, 0), 
(0, 1, 0, 0, 1, 0, 0, 0), 
(0, 1, 1, 0, 1, 0, 0, 0), 
(1, 0, 1, 1, 1, 1, 1, 0), 
(1, 0, 0, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 1, 1, 1, 0), 
(0, 0, 0, 1, 1, 1, 1, 0), 
(1, 1, 0, 1, 0, 1, 0, 0), 
(1, 1, 0, 1, 0, 1, 0, 0), 
(0, 0, 0, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 1, 0, 0, 0, 1, 0), 
(0, 0, 1, 1, 1, 1, 1, 0), 
(0, 0, 1, 1, 1, 1, 1, 0), 
(1, 0, 1, 0, 1, 0, 1, 0), 
(1, 0, 1, 0, 1, 0, 1, 0), 
(1, 0, 1, 0, 0, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 1, 0, 0), 
(0, 0, 1, 0, 1, 1, 1, 0), 
(0, 0, 1, 0, 1, 0, 1, 0), 
(0, 0, 1, 0, 1, 0, 1, 0), 
(0, 0, 1, 1, 1, 1, 1, 0), 
(0, 0, 1, 1, 1, 1, 1, 0), 
(0, 0, 1, 0, 1, 0, 1, 0), 
(0, 0, 1, 0, 1, 0, 1, 0)
), 
((0, 0, 1, 1, 1, 1, 1, 0), 
(0, 1, 1, 1, 1, 1, 1, 0), 
(1, 1, 0, 1, 0, 0, 0, 0), 
(1, 0, 0, 1, 0, 0, 0, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 0, 0, 1, 0, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 1, 0, 0, 1, 1, 0, 0), 
(1, 1, 0, 1, 1, 1, 1, 0), 
(1, 0, 0, 1, 0, 0, 1, 0), 
(1, 0, 0, 1, 0, 0, 1, 0), 
(1, 1, 0, 1, 1, 1, 1, 0), 
(0, 1, 0, 0, 1, 1, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 1, 0, 0, 1, 1, 0, 0), 
(0, 1, 0, 1, 1, 1, 1, 0), 
(0, 0, 0, 1, 0, 0, 1, 0), 
(0, 0, 0, 1, 0, 0, 1, 0), 
(0, 1, 0, 1, 1, 1, 1, 0), 
(0, 1, 0, 0, 1, 1, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 1, 0, 0, 1, 1, 0, 0), 
(0, 1, 0, 1, 1, 1, 1, 0), 
(0, 1, 0, 1, 0, 0, 1, 0), 
(0, 0, 0, 1, 0, 0, 1, 0), 
(0, 0, 0, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 1, 1, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 1, 0, 1, 1, 1, 0, 0), 
(1, 1, 0, 1, 1, 1, 1, 0), 
(1, 0, 0, 0, 0, 0, 1, 0), 
(1, 0, 0, 0, 0, 0, 1, 0), 
(1, 1, 0, 1, 1, 1, 1, 0), 
(0, 1, 0, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 1, 0, 1, 1, 1, 0, 0), 
(0, 1, 0, 1, 1, 1, 1, 0), 
(0, 1, 0, 0, 0, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 1, 0), 
(0, 0, 0, 1, 1, 1, 1, 0), 
(0, 0, 0, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 1, 0, 1, 1, 0, 0, 1), 
(0, 1, 0, 1, 1, 1, 0, 1), 
(0, 0, 0, 0, 0, 1, 0, 1), 
(0, 0, 0, 0, 0, 1, 0, 1), 
(0, 1, 0, 1, 1, 1, 1, 1), 
(0, 1, 0, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((1, 0, 0, 0, 0, 0, 0, 0), 
(1, 0, 0, 1, 1, 0, 0, 0), 
(0, 0, 1, 1, 1, 1, 0, 0), 
(0, 1, 1, 0, 0, 1, 1, 0), 
(0, 1, 1, 0, 0, 1, 1, 0), 
(0, 0, 1, 1, 1, 1, 0, 0), 
(1, 0, 0, 1, 1, 0, 0, 0), 
(1, 0, 0, 0, 0, 0, 0, 0)
), 
((1, 0, 1, 1, 1, 1, 0, 0), 
(1, 0, 1, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 1, 0), 
(1, 0, 1, 1, 1, 1, 1, 0), 
(1, 0, 1, 1, 1, 1, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 1, 1, 0, 0, 0), 
(0, 0, 1, 1, 1, 1, 0, 0), 
(0, 0, 1, 0, 0, 1, 0, 0), 
(1, 1, 1, 0, 0, 1, 1, 1), 
(1, 1, 1, 0, 0, 1, 1, 1), 
(0, 0, 1, 0, 0, 1, 0, 0), 
(0, 0, 1, 0, 0, 1, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 1, 0, 1, 1, 0), 
(0, 1, 1, 1, 1, 1, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 0, 0, 1, 0, 0, 1, 0), 
(1, 1, 0, 0, 0, 0, 1, 0), 
(0, 1, 1, 0, 0, 1, 1, 0), 
(0, 0, 0, 0, 0, 1, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((1, 1, 0, 1, 0, 1, 0, 0), 
(1, 1, 1, 1, 0, 1, 0, 0), 
(0, 0, 1, 1, 1, 1, 1, 1), 
(0, 0, 1, 1, 1, 1, 1, 1), 
(1, 1, 1, 1, 0, 1, 0, 0), 
(1, 1, 0, 1, 0, 1, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((1, 1, 1, 1, 1, 1, 1, 1), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(1, 0, 0, 1, 0, 0, 0, 0), 
(1, 0, 0, 1, 0, 0, 0, 0), 
(1, 1, 1, 1, 0, 1, 0, 0), 
(0, 1, 1, 0, 1, 1, 1, 1), 
(0, 0, 0, 1, 1, 1, 1, 1), 
(0, 0, 0, 0, 0, 1, 0, 1)
), 
((0, 0, 0, 0, 0, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 1, 1), 
(0, 0, 0, 1, 0, 0, 0, 1), 
(0, 1, 1, 1, 1, 1, 1, 1), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 0, 0, 1, 0, 0, 0, 0), 
(1, 1, 0, 0, 0, 0, 0, 0), 
(0, 1, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 1, 0, 0), 
(0, 0, 1, 0, 1, 1, 1, 0), 
(0, 0, 1, 0, 1, 0, 1, 0), 
(1, 0, 1, 0, 1, 0, 1, 0), 
(1, 0, 1, 1, 1, 1, 1, 0), 
(1, 0, 0, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 1, 0, 0, 0, 1, 0), 
(1, 0, 1, 1, 1, 1, 1, 0), 
(1, 0, 1, 1, 1, 1, 1, 0), 
(1, 0, 0, 0, 0, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 1, 1, 0, 0), 
(0, 0, 0, 1, 1, 1, 1, 0), 
(0, 0, 0, 1, 0, 0, 1, 0), 
(0, 1, 0, 1, 0, 0, 1, 0), 
(0, 1, 0, 1, 1, 1, 1, 0), 
(0, 1, 0, 0, 1, 1, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 1, 1, 1, 0, 0), 
(0, 0, 0, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 1, 0), 
(0, 1, 0, 0, 0, 0, 1, 0), 
(0, 1, 0, 1, 1, 1, 1, 0), 
(0, 1, 0, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 1, 0, 1, 1, 1, 1, 0), 
(0, 1, 0, 1, 1, 1, 1, 0), 
(0, 1, 0, 1, 0, 0, 0, 0), 
(0, 1, 0, 1, 0, 0, 0, 0), 
(0, 1, 0, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((1, 0, 1, 1, 1, 1, 1, 0), 
(1, 0, 1, 1, 1, 1, 1, 0), 
(1, 0, 0, 1, 1, 0, 0, 0), 
(1, 0, 0, 0, 1, 1, 0, 0), 
(1, 0, 1, 1, 1, 1, 1, 0), 
(1, 0, 1, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(0, 1, 1, 0, 0, 1, 0, 0), 
(1, 1, 1, 1, 0, 1, 0, 0), 
(1, 0, 0, 1, 0, 1, 0, 0), 
(1, 1, 1, 1, 0, 1, 0, 0), 
(1, 1, 1, 1, 0, 1, 0, 0), 
(0, 0, 0, 1, 0, 1, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(0, 1, 1, 0, 0, 1, 0, 0), 
(1, 1, 1, 1, 0, 1, 0, 0), 
(1, 0, 0, 1, 0, 1, 0, 0), 
(1, 1, 1, 1, 0, 1, 0, 0), 
(0, 1, 1, 0, 0, 1, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 1, 1, 0, 0), 
(0, 0, 0, 1, 1, 1, 1, 0), 
(1, 0, 1, 1, 0, 0, 1, 0), 
(1, 0, 1, 0, 0, 0, 1, 0), 
(0, 0, 0, 0, 0, 1, 1, 0), 
(0, 0, 0, 0, 0, 1, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 1, 1, 1, 0, 0), 
(0, 0, 0, 1, 1, 1, 0, 0), 
(0, 0, 0, 1, 0, 0, 0, 0), 
(0, 0, 0, 1, 0, 0, 0, 0), 
(0, 0, 0, 1, 0, 0, 0, 0), 
(0, 0, 0, 1, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 1, 0, 0, 0, 0), 
(0, 0, 0, 1, 0, 0, 0, 0), 
(0, 0, 0, 1, 0, 0, 0, 0), 
(0, 0, 0, 1, 0, 0, 0, 0), 
(0, 0, 0, 1, 1, 1, 0, 0), 
(0, 0, 0, 1, 1, 1, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((1, 1, 1, 1, 0, 0, 1, 0), 
(1, 1, 1, 1, 0, 1, 1, 0), 
(0, 0, 0, 0, 1, 1, 0, 0), 
(0, 0, 0, 1, 1, 0, 0, 0), 
(0, 0, 1, 1, 0, 0, 1, 1), 
(0, 1, 1, 1, 0, 1, 1, 1), 
(1, 1, 0, 1, 1, 1, 0, 1), 
(1, 0, 0, 0, 1, 0, 0, 1)
), 
((1, 1, 1, 1, 0, 0, 1, 0), 
(1, 1, 1, 1, 0, 1, 1, 0), 
(0, 0, 0, 0, 1, 1, 0, 0), 
(0, 0, 0, 1, 1, 0, 0, 0), 
(0, 0, 1, 1, 0, 1, 1, 0), 
(0, 1, 1, 0, 1, 1, 1, 0), 
(1, 1, 0, 1, 1, 1, 1, 1), 
(1, 0, 0, 1, 1, 1, 1, 1)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(1, 1, 0, 1, 1, 1, 1, 0), 
(1, 1, 0, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 1, 0, 0, 0, 0), 
(0, 0, 1, 1, 1, 0, 0, 0), 
(0, 1, 1, 0, 1, 1, 0, 0), 
(0, 1, 0, 0, 0, 1, 0, 0), 
(0, 0, 0, 1, 0, 0, 0, 0), 
(0, 0, 1, 1, 1, 0, 0, 0), 
(0, 1, 1, 0, 1, 1, 0, 0), 
(0, 1, 0, 0, 0, 1, 0, 0)
), 
((0, 1, 0, 0, 0, 1, 0, 0), 
(0, 1, 1, 0, 1, 1, 0, 0), 
(0, 0, 1, 1, 1, 0, 0, 0), 
(0, 0, 0, 1, 0, 0, 0, 0), 
(0, 1, 0, 0, 0, 1, 0, 0), 
(0, 1, 1, 0, 1, 1, 0, 0), 
(0, 0, 1, 1, 1, 0, 0, 0), 
(0, 0, 0, 1, 0, 0, 0, 0)
), 
((0, 1, 0, 1, 0, 1, 0, 1), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(1, 0, 1, 0, 1, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 1, 0, 1, 0, 1, 0, 1), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(1, 0, 1, 0, 1, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 1, 0, 1, 0, 1, 0, 1), 
(1, 0, 1, 0, 1, 0, 1, 0), 
(0, 1, 0, 1, 0, 1, 0, 1), 
(1, 0, 1, 0, 1, 0, 1, 0), 
(0, 1, 0, 1, 0, 1, 0, 1), 
(1, 0, 1, 0, 1, 0, 1, 0), 
(0, 1, 0, 1, 0, 1, 0, 1), 
(1, 0, 1, 0, 1, 0, 1, 0)
), 
((1, 0, 1, 1, 1, 0, 1, 1), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(0, 1, 0, 1, 0, 1, 0, 1), 
(1, 1, 1, 0, 1, 1, 1, 0), 
(1, 0, 1, 1, 1, 0, 1, 1), 
(0, 1, 0, 1, 0, 1, 0, 1), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(1, 1, 1, 0, 1, 1, 1, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 1, 0, 1, 0, 0, 0), 
(0, 0, 1, 0, 1, 0, 0, 0), 
(0, 0, 1, 0, 1, 0, 0, 0), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 1, 1, 1), 
(0, 0, 0, 0, 1, 1, 1, 1), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 1, 1, 1), 
(0, 0, 0, 0, 1, 1, 1, 1), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 1, 0, 1, 0, 0, 0), 
(0, 0, 1, 0, 1, 0, 0, 0), 
(0, 0, 1, 0, 1, 0, 0, 0), 
(0, 0, 1, 1, 1, 1, 1, 1), 
(0, 0, 1, 1, 1, 1, 1, 1), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 1, 0, 1, 0, 0, 0), 
(0, 0, 1, 0, 1, 0, 0, 0), 
(1, 1, 1, 0, 1, 1, 1, 1), 
(1, 1, 1, 0, 1, 1, 1, 1), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 1, 0, 1, 0, 0, 0), 
(0, 0, 1, 0, 1, 0, 0, 0), 
(0, 0, 1, 0, 1, 1, 1, 1), 
(0, 0, 1, 0, 1, 1, 1, 1), 
(0, 0, 1, 0, 0, 0, 0, 0), 
(0, 0, 1, 1, 1, 1, 1, 1), 
(0, 0, 1, 1, 1, 1, 1, 1), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 1, 0, 1, 0, 0, 0), 
(0, 0, 1, 0, 1, 0, 0, 0), 
(1, 1, 1, 0, 1, 0, 0, 0), 
(1, 1, 1, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(1, 1, 1, 1, 1, 0, 0, 0), 
(1, 1, 1, 1, 1, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(1, 1, 1, 1, 1, 0, 0, 0), 
(1, 1, 1, 1, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(1, 1, 1, 1, 1, 0, 0, 0), 
(1, 1, 1, 1, 1, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 1, 0, 1, 0, 0, 0), 
(0, 0, 1, 0, 1, 0, 0, 0), 
(0, 0, 1, 0, 1, 0, 0, 0), 
(1, 1, 1, 1, 1, 0, 0, 0), 
(1, 1, 1, 1, 1, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 1, 1, 1), 
(0, 0, 0, 0, 1, 1, 1, 1), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(1, 1, 1, 1, 1, 0, 0, 0), 
(1, 1, 1, 1, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0)
), 
((0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(1, 1, 1, 1, 1, 0, 0, 0), 
(1, 1, 1, 1, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0)
), 
((0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 1, 1, 1), 
(0, 0, 0, 0, 1, 1, 1, 1), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0)
), 
((0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0)
), 
((0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(0, 0, 1, 0, 1, 0, 0, 0), 
(0, 0, 1, 0, 1, 0, 0, 0), 
(0, 0, 1, 0, 1, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(0, 0, 0, 0, 1, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(1, 1, 1, 1, 1, 0, 0, 0), 
(1, 1, 1, 1, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(1, 1, 1, 0, 1, 0, 0, 0), 
(1, 1, 1, 0, 1, 0, 0, 0), 
(0, 0, 1, 0, 1, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 1, 1, 1, 1, 1, 1), 
(0, 0, 1, 1, 1, 1, 1, 1), 
(0, 0, 1, 0, 0, 0, 0, 0), 
(0, 0, 1, 0, 1, 1, 1, 1), 
(0, 0, 1, 0, 1, 1, 1, 1), 
(0, 0, 1, 0, 1, 0, 0, 0)
), 
((0, 0, 1, 0, 1, 0, 0, 0), 
(0, 0, 1, 0, 1, 0, 0, 0), 
(1, 1, 1, 0, 1, 0, 0, 0), 
(1, 1, 1, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(1, 1, 1, 0, 1, 0, 0, 0), 
(1, 1, 1, 0, 1, 0, 0, 0), 
(0, 0, 1, 0, 1, 0, 0, 0)
), 
((0, 0, 1, 0, 1, 0, 0, 0), 
(0, 0, 1, 0, 1, 0, 0, 0), 
(0, 0, 1, 0, 1, 1, 1, 1), 
(0, 0, 1, 0, 1, 1, 1, 1), 
(0, 0, 1, 0, 0, 0, 0, 0), 
(0, 0, 1, 0, 1, 1, 1, 1), 
(0, 0, 1, 0, 1, 1, 1, 1), 
(0, 0, 1, 0, 1, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(1, 1, 1, 0, 1, 1, 1, 1), 
(1, 1, 1, 0, 1, 1, 1, 1), 
(0, 0, 1, 0, 1, 0, 0, 0)
), 
((0, 0, 1, 0, 1, 0, 0, 0), 
(0, 0, 1, 0, 1, 0, 0, 0), 
(0, 0, 1, 0, 1, 0, 0, 0), 
(0, 0, 1, 0, 1, 0, 0, 0), 
(0, 0, 1, 0, 1, 0, 0, 0), 
(0, 0, 1, 0, 1, 0, 0, 0), 
(0, 0, 1, 0, 1, 0, 0, 0), 
(0, 0, 1, 0, 1, 0, 0, 0)
), 
((0, 0, 1, 0, 1, 0, 0, 0), 
(0, 0, 1, 0, 1, 0, 0, 0), 
(1, 1, 1, 0, 1, 1, 1, 1), 
(1, 1, 1, 0, 1, 1, 1, 1), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(1, 1, 1, 0, 1, 1, 1, 1), 
(1, 1, 1, 0, 1, 1, 1, 1), 
(0, 0, 1, 0, 1, 0, 0, 0)
), 
((0, 0, 1, 0, 1, 0, 0, 0), 
(0, 0, 1, 0, 1, 0, 0, 0), 
(0, 0, 1, 0, 1, 0, 0, 0), 
(1, 1, 1, 0, 1, 0, 0, 0), 
(1, 1, 1, 0, 1, 0, 0, 0), 
(0, 0, 1, 0, 1, 0, 0, 0), 
(0, 0, 1, 0, 1, 0, 0, 0), 
(0, 0, 1, 0, 1, 0, 0, 0)
), 
((0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(1, 1, 1, 1, 1, 0, 0, 0), 
(1, 1, 1, 1, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(1, 1, 1, 1, 1, 0, 0, 0), 
(1, 1, 1, 1, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0)
), 
((0, 0, 1, 0, 1, 0, 0, 0), 
(0, 0, 1, 0, 1, 0, 0, 0), 
(0, 0, 1, 0, 1, 0, 0, 0), 
(0, 0, 1, 0, 1, 1, 1, 1), 
(0, 0, 1, 0, 1, 1, 1, 1), 
(0, 0, 1, 0, 1, 0, 0, 0), 
(0, 0, 1, 0, 1, 0, 0, 0), 
(0, 0, 1, 0, 1, 0, 0, 0)
), 
((0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 1, 1, 1), 
(0, 0, 0, 0, 1, 1, 1, 1), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 1, 1, 1), 
(0, 0, 0, 0, 1, 1, 1, 1), 
(0, 0, 0, 0, 1, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(1, 1, 1, 1, 1, 0, 0, 0), 
(1, 1, 1, 1, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(1, 1, 1, 1, 1, 0, 0, 0), 
(1, 1, 1, 1, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(1, 1, 1, 1, 1, 0, 0, 0), 
(1, 1, 1, 1, 1, 0, 0, 0), 
(0, 0, 1, 0, 1, 0, 0, 0), 
(0, 0, 1, 0, 1, 0, 0, 0), 
(0, 0, 1, 0, 1, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 1, 1, 1, 1, 1, 1), 
(0, 0, 1, 1, 1, 1, 1, 1), 
(0, 0, 1, 0, 1, 0, 0, 0), 
(0, 0, 1, 0, 1, 0, 0, 0), 
(0, 0, 1, 0, 1, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 1, 1, 1, 1), 
(0, 0, 0, 0, 1, 1, 1, 1), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 1, 1, 1), 
(0, 0, 0, 0, 1, 1, 1, 1), 
(0, 0, 0, 0, 1, 0, 0, 0)
), 
((0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(0, 0, 0, 0, 1, 0, 0, 0)
), 
((0, 0, 1, 0, 1, 0, 0, 0), 
(0, 0, 1, 0, 1, 0, 0, 0), 
(0, 0, 1, 0, 1, 0, 0, 0), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(0, 0, 1, 0, 1, 0, 0, 0), 
(0, 0, 1, 0, 1, 0, 0, 0), 
(0, 0, 1, 0, 1, 0, 0, 0)
), 
((0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(1, 1, 1, 1, 1, 0, 0, 0), 
(1, 1, 1, 1, 1, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 1, 1, 1, 1), 
(0, 0, 0, 0, 1, 1, 1, 1), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0)
), 
((1, 1, 1, 1, 1, 1, 1, 1), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(1, 1, 1, 1, 1, 1, 1, 1)
), 
((0, 0, 0, 0, 1, 1, 1, 1), 
(0, 0, 0, 0, 1, 1, 1, 1), 
(0, 0, 0, 0, 1, 1, 1, 1), 
(0, 0, 0, 0, 1, 1, 1, 1), 
(0, 0, 0, 0, 1, 1, 1, 1), 
(0, 0, 0, 0, 1, 1, 1, 1), 
(0, 0, 0, 0, 1, 1, 1, 1), 
(0, 0, 0, 0, 1, 1, 1, 1)
), 
((1, 1, 1, 1, 1, 1, 1, 1), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(1, 1, 1, 1, 1, 1, 1, 1)
), 
((1, 1, 1, 1, 0, 0, 0, 0), 
(1, 1, 1, 1, 0, 0, 0, 0), 
(1, 1, 1, 1, 0, 0, 0, 0), 
(1, 1, 1, 1, 0, 0, 0, 0), 
(1, 1, 1, 1, 0, 0, 0, 0), 
(1, 1, 1, 1, 0, 0, 0, 0), 
(1, 1, 1, 1, 0, 0, 0, 0), 
(1, 1, 1, 1, 0, 0, 0, 0)
), 
((0, 0, 0, 1, 1, 1, 0, 0), 
(0, 0, 1, 1, 1, 1, 1, 0), 
(0, 0, 1, 0, 0, 0, 1, 0), 
(0, 0, 1, 1, 0, 1, 1, 0), 
(0, 0, 0, 1, 1, 1, 0, 0), 
(0, 0, 1, 1, 0, 1, 1, 0), 
(0, 0, 1, 0, 0, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 1, 1, 1, 1, 1, 1), 
(0, 1, 1, 1, 1, 1, 1, 1), 
(0, 1, 0, 1, 0, 1, 0, 0), 
(0, 1, 0, 1, 0, 1, 0, 0), 
(0, 1, 1, 1, 1, 1, 0, 0), 
(0, 0, 1, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 1, 1, 1, 1, 1, 1, 0), 
(0, 1, 1, 1, 1, 1, 1, 0), 
(0, 1, 0, 0, 0, 0, 0, 0), 
(0, 1, 0, 0, 0, 0, 0, 0), 
(0, 1, 1, 0, 0, 0, 0, 0), 
(0, 1, 1, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 1, 0, 0, 0, 0, 0, 0), 
(0, 1, 1, 1, 1, 1, 1, 0), 
(0, 1, 1, 1, 1, 1, 1, 0), 
(0, 1, 0, 0, 0, 0, 0, 0), 
(0, 1, 1, 1, 1, 1, 1, 0), 
(0, 1, 1, 1, 1, 1, 1, 0), 
(0, 1, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((1, 1, 0, 0, 0, 1, 1, 0), 
(1, 1, 1, 0, 1, 1, 1, 0), 
(1, 0, 1, 1, 1, 0, 1, 0), 
(1, 0, 0, 1, 0, 0, 1, 0), 
(1, 1, 0, 0, 0, 1, 1, 0), 
(1, 1, 0, 0, 0, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 1, 1, 1, 0, 0), 
(0, 0, 1, 1, 1, 1, 1, 0), 
(0, 0, 1, 0, 0, 0, 1, 0), 
(0, 0, 1, 1, 1, 1, 1, 0), 
(0, 0, 1, 1, 1, 1, 0, 0), 
(0, 0, 1, 0, 0, 0, 0, 0), 
(0, 0, 1, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 1), 
(0, 1, 1, 1, 1, 1, 1, 1), 
(0, 1, 1, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 1, 0, 0), 
(0, 0, 0, 0, 0, 1, 0, 0), 
(0, 1, 1, 1, 1, 1, 0, 0), 
(0, 1, 1, 1, 1, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 1, 0, 0, 0, 0, 0), 
(0, 1, 1, 0, 0, 0, 0, 0), 
(0, 1, 0, 0, 0, 0, 0, 0), 
(0, 1, 1, 1, 1, 1, 1, 0), 
(0, 0, 1, 1, 1, 1, 1, 0), 
(0, 1, 1, 0, 0, 0, 0, 0), 
(0, 1, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((1, 0, 0, 1, 1, 0, 0, 1), 
(1, 0, 1, 1, 1, 1, 0, 1), 
(1, 1, 1, 0, 0, 1, 1, 1), 
(1, 1, 1, 0, 0, 1, 1, 1), 
(1, 0, 1, 1, 1, 1, 0, 1), 
(1, 0, 0, 1, 1, 0, 0, 1), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 1, 1, 1, 0, 0, 0), 
(0, 1, 1, 1, 1, 1, 0, 0), 
(1, 1, 0, 1, 0, 1, 1, 0), 
(1, 0, 0, 1, 0, 0, 1, 0), 
(1, 1, 0, 1, 0, 1, 1, 0), 
(0, 1, 1, 1, 1, 1, 0, 0), 
(0, 0, 1, 1, 1, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 1, 1, 0, 0, 1, 0), 
(0, 1, 1, 1, 1, 1, 1, 0), 
(1, 1, 0, 0, 1, 1, 1, 0), 
(1, 0, 0, 0, 0, 0, 0, 0), 
(1, 1, 0, 0, 1, 1, 1, 0), 
(0, 1, 1, 1, 1, 1, 1, 0), 
(0, 0, 1, 1, 0, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 1, 1, 0, 0), 
(0, 0, 0, 1, 1, 1, 1, 0), 
(0, 1, 0, 1, 0, 0, 1, 0), 
(1, 1, 1, 1, 0, 0, 1, 0), 
(1, 0, 1, 1, 1, 1, 1, 0), 
(1, 0, 0, 1, 1, 1, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 1, 1, 0, 0, 0), 
(0, 0, 1, 1, 1, 1, 0, 0), 
(0, 0, 1, 0, 0, 1, 0, 0), 
(0, 0, 1, 1, 1, 1, 0, 0), 
(0, 0, 1, 1, 1, 1, 0, 0), 
(0, 0, 1, 0, 0, 1, 0, 0), 
(0, 0, 1, 1, 1, 1, 0, 0), 
(0, 0, 0, 1, 1, 0, 0, 0)
), 
((0, 0, 0, 1, 1, 0, 0, 1), 
(0, 0, 1, 1, 1, 1, 1, 1), 
(0, 0, 1, 0, 0, 1, 1, 0), 
(0, 0, 1, 1, 1, 1, 0, 0), 
(0, 1, 1, 1, 1, 1, 0, 0), 
(1, 1, 1, 0, 0, 1, 0, 0), 
(1, 0, 1, 1, 1, 1, 0, 0), 
(0, 0, 0, 1, 1, 0, 0, 0)
), 
((0, 0, 1, 1, 1, 0, 0, 0), 
(0, 1, 1, 1, 1, 1, 0, 0), 
(1, 1, 0, 1, 0, 1, 1, 0), 
(1, 0, 0, 1, 0, 0, 1, 0), 
(1, 0, 0, 1, 0, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 1, 1, 1, 1, 1, 1, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(1, 0, 0, 0, 0, 0, 0, 0), 
(1, 0, 0, 0, 0, 0, 0, 0), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(0, 1, 1, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 1, 0, 1, 0, 1, 0, 0), 
(0, 1, 0, 1, 0, 1, 0, 0), 
(0, 1, 0, 1, 0, 1, 0, 0), 
(0, 1, 0, 1, 0, 1, 0, 0), 
(0, 1, 0, 1, 0, 1, 0, 0), 
(0, 1, 0, 1, 0, 1, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 1, 0, 0, 0, 1, 0), 
(0, 0, 1, 0, 0, 0, 1, 0), 
(1, 1, 1, 1, 1, 0, 1, 0), 
(1, 1, 1, 1, 1, 0, 1, 0), 
(0, 0, 1, 0, 0, 0, 1, 0), 
(0, 0, 1, 0, 0, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 1, 0), 
(1, 0, 0, 0, 1, 0, 1, 0), 
(1, 1, 0, 1, 1, 0, 1, 0), 
(0, 1, 1, 1, 0, 0, 1, 0), 
(0, 0, 1, 0, 0, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 1, 0), 
(0, 0, 1, 0, 0, 0, 1, 0), 
(0, 1, 1, 1, 0, 0, 1, 0), 
(1, 1, 0, 1, 1, 0, 1, 0), 
(1, 0, 0, 0, 1, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 1, 1, 1, 1, 1, 1, 1), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(1, 0, 0, 0, 0, 0, 0, 0), 
(1, 1, 1, 0, 0, 0, 0, 0), 
(0, 1, 1, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 1, 1, 0), 
(0, 0, 0, 0, 0, 1, 1, 1), 
(0, 0, 0, 0, 0, 0, 0, 1), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(1, 1, 1, 1, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 1, 0, 0, 0, 0), 
(0, 0, 0, 1, 0, 0, 0, 0), 
(1, 1, 0, 1, 0, 1, 1, 0), 
(1, 1, 0, 1, 0, 1, 1, 0), 
(0, 0, 0, 1, 0, 0, 0, 0), 
(0, 0, 0, 1, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 1, 0, 0, 1, 0, 0), 
(0, 1, 1, 0, 1, 1, 0, 0), 
(0, 1, 0, 0, 1, 0, 0, 0), 
(0, 1, 1, 0, 1, 1, 0, 0), 
(0, 0, 1, 0, 0, 1, 0, 0), 
(0, 1, 1, 0, 1, 1, 0, 0), 
(0, 1, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(0, 1, 1, 0, 0, 0, 0, 0), 
(1, 1, 1, 1, 0, 0, 0, 0), 
(1, 0, 0, 1, 0, 0, 0, 0), 
(1, 1, 1, 1, 0, 0, 0, 0), 
(0, 1, 1, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 1, 1, 0, 0, 0), 
(0, 0, 0, 1, 1, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 1, 1, 0, 0), 
(0, 0, 0, 0, 1, 1, 1, 0), 
(0, 0, 0, 0, 0, 0, 1, 1), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(1, 1, 1, 1, 1, 1, 1, 1), 
(1, 0, 0, 0, 0, 0, 0, 0), 
(1, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(1, 1, 1, 1, 1, 0, 0, 0), 
(1, 1, 1, 1, 1, 0, 0, 0), 
(1, 0, 0, 0, 0, 0, 0, 0), 
(1, 1, 1, 1, 1, 0, 0, 0), 
(0, 1, 1, 1, 1, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(1, 0, 0, 1, 1, 0, 0, 0), 
(1, 0, 1, 1, 1, 0, 0, 0), 
(1, 1, 1, 0, 1, 0, 0, 0), 
(0, 1, 0, 0, 1, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 1, 1, 1, 1, 0, 0), 
(0, 0, 1, 1, 1, 1, 0, 0), 
(0, 0, 1, 1, 1, 1, 0, 0), 
(0, 0, 1, 1, 1, 1, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0)
), 
((0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0), 
(0, 0, 0, 0, 0, 0, 0, 0),
(0, 0, 0, 0, 0, 0, 0, 0),
(0, 0, 0, 0, 0, 0, 0, 0),
(0, 0, 0, 0, 0, 0, 0, 0),
(0, 0, 0, 0, 0, 0, 0, 0),
(0, 0, 0, 0, 0, 0, 0, 0)
)
);

  procedure PrintChar (x, y : integer; Ch : char);
    var
      x2, y2 : integer;
    begin
      for x2:= 0 to 7 do
        for y2:= 0 to 7 do
          case AChar[byte(Ch), x2, y2] of
            1: mem[$a000:x+x2+(y+y2)*320]:= _Ink;
            0: mem[$a000:x+x2+(y+y2)*320]:= _Paper;
          end;
    end;

procedure PrintXY (A, B : integer; Tekst : string);
  var
    c : integer;
  begin
    for c:= 1 to length (Tekst) do begin
      PrintChar (A,B, Tekst[c]);
      A:= A + 8;
      if A > 320-11 then begin
        A:= 0;
        B:= B+8;
      end;
    end;
  end;

procedure _TextColor (c : integer);
  begin
    _Ink:= c mod 256;
  end;

procedure _TextBackGround (c : integer);
  begin
    _Paper:= c mod 256;
  end;

procedure _PutPixel (x, y : integer);
  begin
    mem[$a000:x+y*320]:= _Ink;
  end;

function _GetPixel (x, y : integer) : integer;
  begin
    _GetPixel:= mem[$a000:x+y*320];
  end;

procedure BresenhamLine(x1, y1, x2, y2: Integer);
var
  dx, dy,  p,   x,y,    xEnd,  c : integer;
begin
  dx := abs(x2 - x1);
  dy := abs(y2 - y1);
  if x1 = x2 then begin
    for c:= y1 to y2 do
      _PutPixel (x1, c);
    exit;
  end;
  p := 2 * dy - dx;
  if x1 > x2 then
  begin
    x := x2;
    y := y2;
    xEnd := x1;
  end
  else
  begin
    x := x1;
    y := y1;
    xEnd := x2;
  end;
  _PutPixel(x, y);
  while x < xEnd do
  begin
    x := x + 1;
    if p < 0 then
      p := p + 2 * dy
    else
    begin
      y := y + 1;
      p := p + 2 * (dy - dx);
    end;
    _PutPixel(x, y);
  end;
end;

type
  XYRec = record
    X, Y, Pixel : integer;
  end;

var
  SavedLine    : array[0..777] of XYRec;
  SavedCircle  : array[0..777] of XYRec;
  Count        : integer;
  CountC       : integer;

procedure SaveLine (x1, y1, x2,y2 : integer);
var
  dx, dy,  p,   x, y,    xEnd : integer;
begin
  dx := abs(x2 - x1);
  dy := abs(y2 - y1);
  p := 2 * dy - dx;
  if x1 > x2 then
  begin
    x := x2;
    y := y2;
    xEnd := x1;
  end
  else
  begin
    x := x1;
    y := y1;
    xEnd := x2;
  end;
  Count:= 0;
  SavedLine[Count].x:= x;
  SavedLine[Count].y:= y;
  SavedLine[Count].Pixel:= _GetPixel(x, y);
  while x < xEnd do
  begin
    x := x + 1;
    if p < 0 then
      p := p + 2 * dy
    else
    begin
      y := y + 1;
      p := p + 2 * (dy - dx);
    end;
    if Count < 777 then inc (Count, 1);
    SavedLine[Count].x:= x;
    SavedLine[Count].y:= y;
    SavedLine[Count].Pixel:= _GetPixel(x, y);
  end;
end;

procedure RestoreLine;
  var
    c, OldColour : integer;
  begin
    OldColour:= _Ink;
    for c:= 0 to Count do
      with SavedLine[c] do begin
        _TextColor (Pixel);
        _PutPixel (x, y);
      end;
    _TextColor (OldColour);
  end;

procedure DrawCircle(xc, yc, r: Integer);
var
  x, y, p: Integer;
begin
  x := 0;
  y := r;
  p := 3 - 2 * r;

  while x <= y do
  begin
    _PutPixel(xc + x, yc + y);
    _PutPixel(xc - x, yc + y);
    _PutPixel(xc + x, yc - y);
    _PutPixel(xc - x, yc - y);
    _PutPixel(xc + y, yc + x);
    _PutPixel(xc - y, yc + x);
    _PutPixel(xc + y, yc - x);
    _PutPixel(xc - y, yc - x);

    if p < 0 then
      p := p + 4 * x + 6
    else
    begin
      p := p + 4 * (x - y) + 10;
      y := y - 1;
    end;
    x := x + 1;
  end;
end;

procedure SaveCircle(xc, yc, r: Integer);
var
  _x, _y, p: Integer;
begin
  _x := 0;
  _y := r;
  p := 3 - 2 * r;

  CountC:= 0;
  while (_x <= _y) and (CountC < 777-11) do
  begin
     SavedCircle[CountC].x:= xc+_x;
     SavedCircle[CountC].y:= yc+_y;
     SavedCircle[CountC].Pixel:= _GetPixel (xc+_x, yc+_y);
     inc (CountC, 1);
     SavedCircle[CountC].x:= xc-_x;
     SavedCircle[CountC].y:= yc+_y;
     SavedCircle[CountC].Pixel:= _GetPixel (xc-_x, yc+_y);
     inc (CountC, 1);
     SavedCircle[CountC].x:= xc+_x;
     SavedCircle[CountC].y:= yc-_y;
     SavedCircle[CountC].Pixel:= _GetPixel (xc+_x, yc-_y);
     inc (CountC, 1);
     SavedCircle[CountC].x:= xc-_x;
     SavedCircle[CountC].y:= yc-_y;
     SavedCircle[CountC].Pixel:= _GetPixel (xc-_x, yc-_y);
     inc (CountC, 1);
     SavedCircle[CountC].x:= xc+_y;
     SavedCircle[CountC].y:= yc+_x;
     SavedCircle[CountC].Pixel:= _GetPixel (xc+_y, yc+_x);
     inc (CountC, 1);
     SavedCircle[CountC].x:= xc-_y;
     SavedCircle[CountC].y:= yc+_x;
     SavedCircle[CountC].Pixel:= _GetPixel (xc-_y, yc+_x);
     inc (CountC, 1);
     SavedCircle[CountC].x:= xc+_y;
     SavedCircle[CountC].y:= yc-_x;
     SavedCircle[CountC].Pixel:= _GetPixel (xc+_y, yc-_x);
     inc (CountC, 1);
     SavedCircle[CountC].x:= xc-_y;
     SavedCircle[CountC].y:= yc-_x;
     SavedCircle[CountC].Pixel:= _GetPixel (xc-_y, yc-_x);
     inc (CountC, 1);
    if p < 0 then
      p := p + 4 * _x + 6
    else
    begin
      p := p + 4 * (_x - _y) + 10;
      _y := _y - 1;
    end;
    _x := _x + 1;
  end;
end;

procedure RestoreCircle;
  var
    c, OldColour2 : integer;
  begin
    OldColour2:= _Ink;
    for c:= 0 to CountC do
      with SavedCircle[c] do begin
         _Textcolor (Pixel);
         _PutPixel (x, y);
      end;
    _TextColor (OldColour2);
  end;


procedure FillCircle (x, y, r : integer);
  var
    c, c2 : integer;
  begin
    for c:= y downto y-r do begin
      for c2:= x downto x-r do begin
        if _GetPixel (c2, c)=
          _Ink then break
          else begin
            mem[$a000:c2+c*320]:= _Paper;
          end;
      end;
      for c2:= x+1 to x+r do begin
        if _GetPixel (c2, c)=
          _Ink then break
          else begin
            mem[$a000:c2+c*320]:= _Paper;
          end;
      end;
    end;
    for c:= y+1 to y+r do begin
      for c2:= x downto x-r do begin
        if _GetPixel (c2, c)=
          _Ink then break
          else begin
            mem[$a000:c2+c*320]:= _Paper;
          end;
      end;
      for c2:= x+1 to x+r do begin
        if _GetPixel (c2, c)=
          _Ink then break
          else begin
            mem[$a000:c2+c*320]:= _Paper;
          end;
      end;
    end;
  end;

(*  {
procedure plot_ellipse(x_center, y_center, a, b : integer);
  var
    x,y, a2,b2, two_a2,two_b2, dx,dy : integer;
    d1,d2 : real;
  begin
    x := 0;
    y := b;
    a2 := a * a;
    b2 := b * b;
    two_a2 := 2 * a2;
    two_b2 := 2 * b2;

  {(*  # Region 1*)(*}
    d1 := b2 - (a2 * b) + (0.25 * a2);
    dx := two_b2 * x;
    dy := two_a2 * y;

(*    points = []*)  (*

    while (dx < dy) do begin
        _PutPixel(x_center + x, y_center + y);
        _PutPixel(x_center - x, y_center + y);
        _PutPixel(x_center + x, y_center - y);
        _PutPixel(x_center - x, y_center - y);

        if d1 < 0 then begin
            x:= x + 1;
            dx := dx + two_b2;
            d1 := d1 + dx + b2;
        end
        else begin
            x:= 1;
            y:= 1;
            dx:= dx + two_b2;
            dy := dy - two_a2;
            d1 := d1 + dx - dy + b2
        end;
    end;
{    # Region 2}
    d2:= (b2 * (x + 0.5) * (x + 0.5)) + (a2 * (y - 1) * (y - 1)) - (a2 * b2);

    while (y >= 0) do begin
        _PutPixel(x_center + x, y_center + y);
        _PutPixel(x_center - x, y_center + y);
        _PutPixel(x_center + x, y_center - y);
        _PutPixel(x_center - x, y_center - y);

        if (d2 > 0) then begin
            y := y - 1;
            dy := dy - two_a2;
            d2 := d2 + a2 - dy;
        end
        else begin
            y := y - 1;
            x := x + 1;
            dx := dx + two_b2;
            dy := dy - two_a2;
            d2 := d2 + dx - dy + a2;
        end;
    end;
(*    return points*)  (*
  end;
   *)
procedure DrawRectangle (x,y, x2,y2 : integer);
  begin
    BresenHamLine (x,y, x2,y);
    BresenHamLine (x,y2, x2,y2);
    BresenHamLine (x,y, x,y2);
    BresenHamLine (x2,y, x2,y2);
  end;

procedure Cls;
  begin
    fillchar (mem[$a000:0], 64000, _Paper);
  end;

PROCEDURE SetPalette(pal:Palette; update:BOOLEAN);
{ in: pal = Zeiger auf zu setzende Palette }
{     update = TRUE/FALSE fr: ShadowTab neu/nicht neu berechnen}
{out: ActualColors = aktuelle Farbpalette  }
{rem: Palette wurde bernommen und evtl. ShadowTab neuberechnet }
var
  o : word;
BEGIN
 ActualColors:=pal;  {Farbpalette in ActualColors bernehmen}
 O:= ofs (ActualColors);
 ASM
   MOV SI,O {DS:SI = ^ActualColors[]}

   CLI

    mov dx,StatusReg
  @WaitNotVSyncLoop:
    in   al,dx
    and  al,8
    jnz  @WaitNotVSyncLoop
  @WaitVSyncLoop:
    in   al,dx
    and  al,8
    jz   @WaitVSyncLoop

   MOV DX,3C8h
   XOR AL,AL
   OUT DX,AL
   INC DX

   MOV CX,256/2
  @L1:
   LODSW
   OUT DX,AL
   MOV AL,AH
   OUT DX,AL
   LODSW
   OUT DX,AL
   MOV AL,AH
   OUT DX,AL
   LODSW
   OUT DX,AL
   MOV AL,AH
   OUT DX,AL
   LOOP @L1

   STI
 END; {of ASM}
END;

PROCEDURE GetPalette(VAR pal:Palette); ASSEMBLER;
{ in: pal = Zeiger auf Palette-Speicher}
{out: pal = momentan aktuelle Palette  }
ASM
   CLI
   XOR AL,AL
   MOV DX,3C7h
   OUT DX,AL
   LES DI,pal
   MOV CX,768
   MOV DX,3C9h
  @L1:
   IN AL,DX
   STOSB
   LOOP @L1
   STI
END;

PROCEDURE FadeToPalette(destPal:Palette; AnzSteps:WORD);
{ in: ActualColors = aktuell gesetzte Farbpalette}
{     destPal  = Zielpalette}
{     AnzSteps = Zwischenschrittanzahl}
{out: ActualColors = destPal}
{rem: Die Prozedur blendet von ActualColors zu destPal ber, und zwar}
{     in AnzSteps Schritten}
{     Das Palettesetzen wird auf den vertikalen Retrace synchronisiert,}
{     so da ein Zwischenschritt mindestens 1/70 sec bentigt}
VAR oldColors,pal:Palette;
    i,steps:INTEGER;
    s,d:POINTER;
BEGIN
 dec(anzsteps);
 IF anzsteps<1
  THEN steps:=1
  ELSE steps:=anzsteps; {steps ins selbe Segment wie pal bringen}
 oldColors:=ActualColors;
 pal:=destpal;    {pal und oldColors ins selbe Segment bringen}
 s:=@pal; d:=@ActualColors;
 FOR i:=0 TO steps-1 DO
  BEGIN
   {jetzt per Assembler folgende Sequenz berechnen:}
   { FOR c:=0 TO 255 DO  }
   {  BEGIN              }
   {   ActualColors[c].red:=LONGINT(pal[c].red-oldColors[c].red)*i }
   {    DIV steps+ oldColors[c].red;                               }
   {   ActualColors[c].green:=LONGINT(pal[c].green-oldColors[c].green)*i }
   {     DIV steps+ oldColors[c].green;  }
   {   ActualColors[c].blue:=LONGINT(pal[c].blue-oldColors[c].blue)*i }
   {     DIV steps+ oldColors[c].blue; }
   {  END;  }

   ASM
    LES DI,d  {ES:DI = Zeiger auf ActualColors-Tabelle}
    LDS SI,s  {DS:SI = Zeiger auf pal-Tabelle}
    MOV BX,OFFSET oldColors-OFFSET pal -1  {DS:SI+BX+1 = Zeiger auf oldColors}

    MOV CX,256
   @docolor:
    XOR AH,AH
    LODSB           {AX := pal[c].red}
    SUB AL,[SI+BX]  
    SBB AH,0        {AX := pal[c].red - oldColors[c].red = delta}
    IMUL i          {DX:AX := delta * i}
    IDIV steps      {AX := delta * i/steps}
    ADD AL,[SI+BX]  {AX := delta * i/steps + oldColors[c].red}
    STOSB

    {dto. fr grn}
    XOR AH,AH
    LODSB
    SUB AL,[SI+BX]
    SBB AH,0
    IMUL i
    IDIV steps
    ADD AL,[SI+BX]
    STOSB

    {dto. fr blau}
    XOR AH,AH
    LODSB
    SUB AL,[SI+BX]
    SBB AH,0
    IMUL i
    IDIV steps
    ADD AL,[SI+BX]
    STOSB

    LOOP @docolor

    MOV AX,SEG @DATA
    MOV DS,AX
   END;
   SetPalette(ActualColors,FALSE)
  END;
 SetPalette(pal,TRUE)
END;

procedure ZetKleur (Nummer : word; Rood, Groen, Blauw : byte);
  begin
    asm
      mov ah,$10;
      mov al,$10;
      mov bx,Nummer;
      mov dh, Rood;
      mov ch, Groen;
      mov cl, Blauw;
      int $10;
    end;
  end;

procedure ZetPallet (pal : palettetype);
  var
    c : integer;
  begin
    for c:= 0 to 255 do
      ZetKleur (c, pal[c, 1], pal[c, 2], pal[c, 3]);
  end;

begin
  nosound;
end.
