'TXT89a.BAS (c) Copyright 1990 Lawrence Gozum & Marvin Gozum, MD.

'Greeting GIF Developers and QB fans !

'This QB demo shows how to integrate TXT89A.ASM routines into a
'QB GIF89a decoder.  TXT89A.OBJ can be linked with any of your
'*.QLB QB libraries or added to your *.LIB for stand-alone
'integration without the BRUN41.exe runtime-module.

'Here, the default 8x8 system bitmap font is used and expanded
'to 16x16 character cells using the default 256-color palette.
'You can actually 'bload' your own chracter definition in a reserved
'area of memory and point CHARseg and CHARptr to it.

'Initially, a quarter of the screen will be filled with random dots.
'After pressing any key, 96 character from &H20 to &H7F will be printed
'with rainbow colors against a black background.

'The transparency flag is set, thus you should see the random dots
'showing 'thru' the characters.

'This code (ie., TXT89A.BAS) is hereby released to the Public Domain and
'can be used anywhere and by anyone in ANY fashion they choose.  We hope
'this will encourage the acceleration of GIF89a decoder development.  
'A little acknowldegement of its use or variation of its use would be more
'than appreciated.

'I hope this helps you.  Enjoy.

'lawrence - 09 September 1990


DEFINT A-Z
DECLARE SUB dec2int (f AS SINGLE, i AS INTEGER)
RANDOMIZE TIMER

SCREEN 13
DIM CHX(256) AS INTEGER
DIM CHY(256) AS INTEGER

CHXseg = VARSEG(CHX(0)): '        interpolated x look-up table
CHXptr = VARPTR(CHX(0))

CHYseg = VARSEG(CHY(0)): '        interpolated y look-up table
CHYptr = VARPTR(CHY(0))


'DEC2INT sub-routine adjusts the floating point vectors to integer values

DEF SEG = 0
v1! = PEEK(&H10C): v2! = PEEK(&H10C + 1)
CharLo! = v1! + v2! * 256: CALL dec2int(CharLo!, CHARptr)
v1! = PEEK(&H10C + 2): v2! = PEEK(&H10C + 3)
CharHi! = v1! + v2! * 256: CALL dec2int(CharHi!, CHARseg)

COLOR 15
LOCATE 20, 1: PRINT "Press any key to show characters."

tflag = 1: '            transparency flag 1=ON 0=OFF
tcolor = 15: '          transparaent color
CharBits = 8: '         width of source character cells
CharL = 8: '            height of source character cells
CharW = 16: '           user defined character width
CharH = 16: '           user defined character height

'pass your parameters
CALL CharParms(CHARseg, CHARptr, CharW, CharH, CharL, tflag, tcolor)

'pass interpolation data
FOR x = 0 TO CharW: CHX(x) = INT(CharBits * x / CharW): NEXT
CALL GetCharXpts(CHXseg, CHXptr)
FOR y = 0 TO CharH: CHY(y) = INT(CharL * y / CharH): NEXT
CALL GetCharYpts(CHYseg, CHYptr)

'plot some random dots to demonstrate transparency

DO WHILE a$ = ""
        x = RND * 160
        y = RND * 100
        PSET (x, y), tcolor
        a$ = INKEY$
LOOP

bc = 0
fc = 32
FOR y = 2 TO 7
        x1 = y * 16: x2 = x1 + 15
        x = 0
        yy = y * (CharH + 1)
        FOR char = x1 TO x2
                fc = fc + 1
                CALL XVGAtext(char, x, yy, fc, bc)
                x = x + CharW + 1
        NEXT
NEXT
GOTO quit

quit:
a$ = INPUT$(1)
SCREEN 0: WIDTH 80: CLS
END

DEFSNG A-Z
SUB dec2int (f AS SINGLE, i AS INTEGER)
        IF f <= 32767 THEN i = FIX(f): EXIT SUB
        ii! = -65536 + f
        i = CINT(ii!)
END SUB

