#define TBM_CREATEBUTTON   (WM_USER+100)

#define IDM_HELP                1999
#define IDM_NEW                 2000
#define IDM_OPEN                2001
#define IDM_SAVE                2002
#define IDM_SAVEAS              2003
#define IDM_CLOSE               2004
#define IDM_EXIT                2005
#define IDM_ABOUT               2006
#define IDM_COPY                2010
#define IDM_PASTE               2011
#define IDM_UNDO                2012
#define IDM_SMALLBRUSH          2020
#define IDM_MEDIUMBRUSH         2021
#define IDM_LARGEBRUSH          2022

#define ID_PENCIL               256
#define ID_LINE                 257
#define ID_OPENRECT             258
#define ID_FILLRECT             259
#define ID_CIRCLE               260
#define ID_FILLCIRC             261
#define ID_SELECT               262
#define ID_FLOOD                263

#define ID_COLOR0               200
#define ID_COLOR1               201
#define ID_COLOR2               202
#define ID_COLOR3               203
#define ID_COLOR4               204
#define ID_COLOR5               205
#define ID_COLOR6               206
#define ID_COLOR7               207
#define ID_COLOR8               208
#define ID_COLOR9               209
#define ID_COLOR10              210
#define ID_COLOR11              211
#define ID_COLOR12              212
#define ID_COLOR13              213
#define ID_COLOR14              214
#define ID_COLOR15              215

#define ID_ROPBASE              700


#pragma pack(1)

typedef struct tagIconHeader
{
  WORD icoReserved;
  WORD icoResourceType;  /* must be 1 */
  WORD icoResourceCount;
/*
  ICONDIRECTORY icoDir[icoResourceCount];
*/
} ICONHEADER;

typedef struct tagIconDirectory
{
  BYTE Width;
  BYTE Height;
  BYTE ColorCount;
  BYTE bReserved1;
  WORD bReserved2;
  WORD bReserved3;
  DWORD icoDIBSize;    /* number of bytes */
  DWORD icoDIBOffset;  /* byte offset from start of file to image */
/*
  BYTE  image[];
*/
} ICONDIRECTORY;


typedef struct tagRGB
{
  BYTE  red,
        green,
        blue;
} RGB;


#define MAXTOOLS  32

typedef struct tagToolInfo
{
  int    idTool;
  HANDLE hData;
  WORD   wToolStyle;
#define TOOL_ICON   1
#define TOOL_COLOR  2
} TOOLINFO;

typedef struct tagToolBox
{
  int  nRows;
  int  cxButton, 
       cyButton;
  int  nButtons;
  int  idSelectedTool;
  HWND hwndSelectedTool;
  TOOLINFO toolInfo[MAXTOOLS];
} TOOLBOX, FAR *LPTOOLBOX;


typedef struct tagIconInfo
{
  HICON  hIcon;
  HANDLE hBitmapBits;
  HANDLE hBitmapInfo;
  WORD   fFlags;
#define STATE_DIRTY   0x0001
#define STATE_SOMETHING_SELECTED  0x0002
  char   szFilename[128];
} ICONINFO;


extern HWND   hWndMain;
extern HWND   hWndEdit;
extern HWND   hWndActualImage;
extern HWND   hWndDebug;
extern HANDLE hInst;
extern ICONINFO IconInfo;
extern ICONHEADER IconHeader;
extern ICONDIRECTORY IconDir;
extern WORD CurrentColor;
extern WORD iCurrentTool;

extern  int  PASCAL WinMain(WORD hInstance,WORD hPrevInstance,char FAR *lpCmdLine,int nCmdShow);
extern  int ICOViewInit(WORD hInstance);
extern  VOID PASCAL NewIcon(void);
extern  int  PASCAL ColorCountToPlanes(int nClr);
extern  VOID PASCAL SetIconPixel(int x,int y,int iColor);
extern  int  PASCAL GetIconPixel(int x,int y);
extern  VOID PASCAL FAR IconPlotLine(int x,int y,char FAR *lpData);
extern  int  PASCAL FAR OpenFileDlgProc(WORD hDlg,WORD message,WORD wParam,long lParam);
extern  VOID UpdateListBox(WORD hDlg);
extern  VOID ChangeDefExt(char near *Ext,char near *Name);
extern  VOID SeparateFile(char FAR *lpDestPath,char FAR *lpDestFileName,char FAR *lpSrcFileName);
extern  int  PASCAL FAR SaveAsDlgProc(WORD hDlg,WORD message,WORD wParam,long lParam);
extern  long PASCAL FAR ICOViewWndProc(HWND hWnd,WORD message,WORD wParam,long lParam);
extern  long PASCAL FAR ICOEditWndProc(HWND hWnd,WORD message,WORD wParam,long lParam);
extern  long PASCAL FAR ICOImageWndProc(HWND hWnd,WORD message,WORD wParam,long lParam);
extern  long PASCAL FAR ICODebugWndProc(HWND hWnd,WORD message,WORD wParam,long lParam);
extern  BOOL PASCAL IconPromptForSave(HWND hWnd);
extern  VOID PASCAL IconUndo(void);
extern  VOID PASCAL IconCheckpoint(void);
extern  BOOL FAR PASCAL About(HWND, unsigned, WORD, LONG);
extern  VOID PASCAL InvalidateAllWindows(void);

/* Icondraw.C */
extern  VOID PASCAL DisplayDIBitmap(HWND hWnd,WORD hDC,WORD hBits);
extern  VOID PASCAL DrawCircleInBitmap(HWND hWnd,WORD hDC,WORD hBits,int x1,int y1,int x2,int y2);
extern  VOID PASCAL FloodFillBitmap(HWND hWnd,HDC hDC,HANDLE hBits,int x1,int y1);

/* Icoread.C */
extern  int  ICORead(HWND hWnd,char *pszFile);

/* Icowrite.C */
extern  int  ICOWrite(char *pszFile,WORD hBits);

/* Select.C */
extern  VOID PASCAL StartSelection(HWND hWnd,struct tagPOINT ptCurrent,struct tagRECT FAR *lpSelectRect,int idTool);
extern  VOID PASCAL UpdateSelection(HWND hWnd,struct tagPOINT ptCurrent,struct tagRECT FAR *lpSelectRect,int idTool);
extern  VOID PASCAL EndSelection(struct tagPOINT ptCurrent,LPRECT lpSelectRect);
extern  VOID PASCAL ClearSelection(HWND hWnd,struct tagRECT FAR *lpSelectRect,int idTool);
extern  VOID PASCAL SortRect(struct tagRECT FAR *lpRect);

/* Toolbox.C */
extern  BOOL PASCAL ToolboxInit(HWND hWnd);
extern  LONG PASCAL FAR ToolBoxWndProc(HWND hWnd,WORD message,WORD wParam,long lParam);
extern  VOID PASCAL DrawUserButton(HWND hWnd,WORD hDC,LPRECT lpRect,int idCtrl,WORD iState,WORD hData,WORD wStyle,int bCurrent);

