Program High_Resolution_Timer_Test;

{$N+}
{$E+}

Uses CRT,DOS,QwkTimer;

Var Seconds   : Word;
    SubSec    : Word;
    SubSecStr : String;
    T_Elapsed : Real;
    _Delay    : Real;

Begin
  ClrScr;
  WriteLn('  The purpose of this program is to demonstrate the capabilities of');
  WriteLn('the QwkTimer high resolution timer unit. This demonstration program');
  WriteLn('is preprogrammed to operate at a frequency of 1820 hertz ( or about');
  WriteLn('100 times faster than the default timer rate ). You must supply the');
  WriteLn('number of seconds the program is to delay for.  The value you enter');
  WriteLn('may be accurate to approximately 550 microseconds (0.00055 seconds)');
  WriteLn('For example, you may enter a value of 15.00055, or perhaps 7.1, etc');
  WriteLn;
  Write('Delay for how many seconds:');
  ReadLn(_Delay);
  ClrScr;
  TimerOn(1820);
  Write('Press [RETURN] to start...');
  ReadLn;
  WriteLn;
  WriteLn('Time Elapsed = ');
  ResetTimer;
  Repeat
    T_Elapsed:=TimeElapsed;
    Seconds:=Trunc(T_Elapsed);
    SubSec:=Trunc(Frac(T_Elapsed)*10000);
    Str(SubSec,SubSecStr);
    While Length(SubSecStr)<4 do SubSecStr:='0'+SubSecStr;
    GotoXY(16,3);
    Write(Seconds,':',SubSecStr,' ');
  Until (T_Elapsed>=_Delay) or (Keypressed);
  WriteLn;
  If T_Elapsed<_Delay then WriteLn('Delay aborted.')
                      else WriteLn('Done.');
  TimerOff;
End.

