
program CORE4 (input, output);

uses
  CORE3;

TYPE PaletteEntry=RECORD red,green,blue:BYTE END;
     Palette=ARRAY[0..255] OF PaletteEntry;
     PalettePtr=^Palette;

var
  ACTUALCOLORS                  : PALETTE;
  F                             : file;
  CRTAddress, StatusReg         : WORD;
  C                             : byte;

(*
PROCEDURE SetPalette(pal:Palette; update:BOOLEAN);
{ in: pal = Zeiger auf zu setzende Palette }
{     update = TRUE/FALSE fr: ShadowTab neu/nicht neu berechnen}
{out: ActualColors = aktuelle Farbpalette  }
{rem: Palette wurde bernommen und evtl. ShadowTab neuberechnet }
BEGIN
 IF @pal<>@ActualColors
  THEN ActualColors:=pal;  {Farbpalette in ActualColors bernehmen}
 ASM
   MOV SI,OFFSET ActualColors  {DS:SI = ^ActualColors[]}

   CLI

    mov dx,StatusReg
  @WaitNotVSyncLoop:
    in   al,dx
    and  al,8
    jnz  @WaitNotVSyncLoop
  @WaitVSyncLoop:
    in   al,dx
    and  al,8
    jz   @WaitVSyncLoop

   MOV DX,3C8h
   XOR AL,AL
   OUT DX,AL
   INC DX

   MOV CX,256/2
  @L1:
   LODSW
   OUT DX,AL
   MOV AL,AH
   OUT DX,AL
   LODSW
   OUT DX,AL
   MOV AL,AH
   OUT DX,AL
   LODSW
   OUT DX,AL
   MOV AL,AH
   OUT DX,AL
   LOOP @L1

   STI
 END; {of ASM}
END;
*)

begin
  writeln;
  if paramcount < 1 then begin
    writeln;
    writeln ('CORE4.EXE sets the palette 256xRED_GREEN_BLUE palettes... ....');
    writeln ('usage: ', paramstr (0), ' <palette_file> .... ... ... ...');
    halt (0);
  end;
(*  ASM  {ermitteln, ob Farb- oder Monochromdarstellung}
    MOV DX,3CCh  {Output-Register befragen:}
    IN AL,DX
    TEST AL,1    {ist es ein Farbbildschirm?}
    MOV DX,3D4h
    JNZ @L1      {ja  }
    MOV DX,3B4h  {nein}
   @L1:          {DX = 3B4h / 3D4h = CRTAddress-Register fr monochrom/Farbe}
    MOV CRTAddress,DX
    ADD DX,6     {DX = 3BAh / 3DAh = Status-Register fr monochrom/Farbe}
    MOV StatusReg,DX
  END; {of ASM}
*)
  assign (F, paramstr(1));
  reset (F, 256*3);
  blockread (F, ACTUALCOLORS, 1);
  close (F);
  for C:= 0 to 255 do
    SetPal (C, ACTUALCOLORS[C].RED, ACTUALCOLORS[C].GREEN,
      ACTUALCOLORS[C].GREEN
    );
end.