
unit CORE5;

interface

uses
  crt, CORE, CORE2;

procedure READLNMCGA (var TEKST : string);
procedure READLNVGA (var TEKST : string);

implementation

procedure READLNMCGA (var TEKST : string);
  var
    Ch    : char;
    X, Y  : integer;
  begin
      TEKST:= '';
    directvideo:= false;
    X:= wherex;
    Y:= wherey;
    repeat
      directvideo:= false;
      gotoxy (X, Y);
      PRINTMCGA (TEKST);
      ANIMATECURSORMCGA;
      Ch:= READKEY;
      if Ch <> #0 then begin
        case CH of
          #8: begin
            PRINTMCGA (#8#8'  '#8#8);
            delete (TEKST, length (TEKST), 1);
          end
            else begin
              if length (TEKST) < 40-X+1 then
                TEKST:= TEKST + CH;
            end;
        end;
      end;
    until Ch = #13;
  end;

procedure READLNVGA (var TEKST : string);
  var
    Ch    : char;
    X, Y  : integer;
  begin
    X:= wherex;
    Y:= wherey;
    TEKST:= '';
    repeat
      gotoxy (X, Y);
      PRINTVGA ((X-1)*8, (Y-1)*8, TEKST);
      ANIMATECURSORVGA;
      Ch:= READKEY;
      if Ch <> #0 then begin
        case CH of
          #8: begin
            delete (TEKST, length (TEKST), 1);
            GOTOXY (X, Y);
            PRINTVGA ((X-1)*8, (Y-1)*8, TEKST + ' ');
          end
            else begin
              if length (TEKST) < 40-X+1 then
                TEKST:= TEKST + CH;
            end;
        end;
      end;
    until Ch = #13;
  end;

begin

end.