
program CIRKEL (input, output);

var
  X,Y, R : integer;
  TEKST  : string;
  CODE   : integer;
  FCOLOR : integer;

procedure POINTMCGA (X, Y : integer);
  begin
    mem[$A000:X + Y*320]:= FColor;
  end;

procedure CIRCLEMCGA (XC, YC : integer; R : integer);
var
  x, y, p: Integer;
begin
  x := 0;
  y := r;
  p := 1 - r;

  while x <= y do
  begin
    pointmcga (xc + x, yc + y);
    pointmcga (xc - x, yc + y);
    pointmcga (xc + x, yc - y);
    pointmcga (xc - x, yc - y);
    pointmcga (xc + y, yc + x);
    pointmcga (xc - y, yc + x);
    pointmcga (xc + y, yc - x);
    pointmcga (xc - y, yc - x);

    if p < 0 then
      p := p + 2 * x + 3
    else
    begin
      p := p + 2 * (x - y) + 5;
      y := y - 1;
    end;
    x := x + 1;
  end;
end;

procedure CHECKCODE;
  var
    OK   : boolean;
  begin
    OK:= (CODE = 0);
    if not OK then begin
      writeln ('Fout in integer constante');
      halt (22);
    end;
  end;

begin
  if paramcount < 4 then begin
    writeln;
    writeln (' dit programma tekent een cirkel op het mcga scherm');
    writeln;
    writeln ('    gebruik: CIRKEL[.EXE] <XCOOR> <YCOOR> <RADIUS> <KLEUR> ....');
    halt (21);
  end;
  TEKST:= paramstr (1);
  val (TEKST, X, CODE);
  CheckCode;
  TEKST:= paramstr (2);
  val (TEKST, Y, CODE);
  CheckCode;
  TEKST:= paramstr (3);
  val (TEKST, R, CODE);
  CheckCode;
  TEKST:= paramstr (4);
  val (TEKST, FCOLOR, CODE);
  CheckCode;
  CIRCLEMCGA (X,Y, R);
end.
