
unit CYPHER;

interface

uses
  STRINGS2, CAL, ERRORS;

function Infix (Tekst : string) : real;
function EvaluateString (Tekst : string) : string;
function Anything (Tekst : string) : string;

implementation

  function IsString (Tekst : string) : boolean;
    var
      Say, ascii          : real;
      c, p                : byte;
      Temp                : boolean;
      IsNumber            : boolean;
    begin
      Tekst:= upstring (Tekst);
      Temp:= (pos ('$', Tekst) > 0);
      Say:= 0;
      for c:= 1 to length (Tekst) do
        if Tekst[c] = '"' then
          Say:= Say + 1;
      ascii:= 0;
      p:= pos ('ASC', Tekst);
      while (not (p = 0)) do begin
        ascii:= ascii + 1;
        delete (Tekst, p, 3);
        p:= pos ('ASC', Tekst);
      end;
      if Ascii > 0 then begin
        IsNumber:= (not Temp) and (Say / 2 = Ascii);
        IsString:= not IsNumber;
      end
          else
            IsString:= Temp or (pos('"', Tekst) > 0);
(*      if Ascii > 0 then
        IsString:= not ((not Temp) and (not (Say = Ascii*2)))
          else
            IsString:= Temp or (pos ('"', Tekst) > 0);
*)
    end;

function Infix (Tekst : string) : real;
  begin
    Infix:= Evaluate (Tekst);
  end;

function EvaluateString (Tekst : string) : string;
  var
    Brackets, c    : byte;
  begin
    Brackets:= 0;
    c:= 1;
    repeat
      case Tekst[c] of
        '(': inc (Brackets, 1);
        ')': Brackets:= Brackets - 1;
        '+': if (Brackets = 0) then begin
          delete (Tekst, c, 1);
          insert ('&&', Tekst, c);
          c:= c + 1;
        end;
      end;
      inc (c, 1);
    until c > length(Tekst);
    EvaluateString:= EvaluateTekst0 (Tekst);
  end;

function Anything (Tekst : string) : string;
  var
    R        : real;
    Tekst2   : string;
  begin
    case IsString (Tekst) of
      true  :  Anything:= EvaluateString (Tekst);
      false : begin
        R:= Infix (Tekst);
        str (R : 10 : 5, Tekst2);
        Anything:= Tekst2;
      end;
    end;
  end;

begin
end.