
unit READING;

interface

uses
  QWKTIMER, PRINTING;

procedure READLNVGA (var TEKST : string);

var
  ESCAPE, UP, DOWN, PAGEUP, PAGEDOWN : boolean;

implementation

procedure PAUZE (WAITINGNUMBER : integer);
  var
    C  : integer;
  begin
    TimerOn (18);
    ResetTimer;
    repeat
    until (TimeElapsed > WAITINGNUMBER) or KEYPRESSED;
    TimerOff;
  end;

procedure READLNVGA (X, Y : integer; var TEKST : string);
  var
    Ch    : char;
  begin
    TEKST:= '';
    repeat
      PRINTXY (X, Y, TEKST + #176+' ');
      PAUZE (50);
      PRINTXY (X, Y, TEKST + '  ');
      PAUZE (30);
      Ch:= READKEY;
      if Ch <> #0 then begin
        case CH of
          'H': UP:= TRUE;
          'P': DOWN:= TRUE;
          'I': PAGEUP:= TRUE;
          'Q': PAGEDOWN:= TRUE;
          #8: begin
            delete (TEKST, length (TEKST), 1);
          end
            else begin
              if length (TEKST) < 79-X+1 then
                TEKST:= TEKST + CH;
            end;
        end;
      end
        else CH:= READKEY;
    until (Ch in [#13, #27]) or UP or DOWN or PAGEUP or PAGEDOWN;
    ESCAPE:= CH = #27;
  end;

begin

end.
