
unit STRINGS;

interface

uses
  CYPHER;

function  CALCSTRING (TEKST : string) : string;

implementation

function BRACKETSOK (TEKST : string) : boolean;
  var
    O, C  : byte;
  begin
    O:= 0;
    while (pos('{', TEKST) > 0) do begin
      inc (O, 1);
      delete (TEKST, pos('{', TEKST), 1);
    end;
    C:= 0;
    while (pos('}', TEKST) > 0) do begin
      inc (C, 1);
      delete (TEKST, pos('}', TEKST), 1);
    end;
    BRACKETSOK:= (O = C);
  end;

function COUNTBRACKETS (TEKST : string) : integer;
  var
    O, C  : byte;
  begin
    O:= 0;
    while (pos('{', TEKST) > 0) do begin
      inc (O, 1);
      delete (TEKST, pos('{', TEKST), 1);
    end;
    COUNTBRACKETS:= O;
  end;

function  HaalBinnenste (Tekst : string; var B : byte; var E : byte) : string;
  label
    QUIT;
  var
    C   : integer;
    TEMP: string;
  begin
    TEMP:= '';
    B:= 0;
    E:= 0;
    for C:= 1 to length (TEKST) do begin
      case TEKST[C] of
        '{': begin
          B:= C;
          TEMP:= '{';
        end;
        '}': begin
          E:= C;
          TEMP:= TEMP + '}';
          goto QUIT;
        end;
        else
          TEMP:= TEMP + TEKST[C];
      end;
    end;
    QUIT:;
    HAALBINNENSTE:= TEMP;
  end;

  procedure TRIM (var TEKST : string);
    begin
      while (TEKST[1] = ' ') do
        delete (TEKST, 1, 1);
      while (TEKST[length(TEKST)] = ' ') do
        delete (TEKST, length (TEKST), 1);
    end;

  function INSERTBRACKETS (TEKST : string) : string;
    begin
      if pos ('MID$', TEKST) > 0 then begin
        insert ('(', TEKST, pos('MID$', TEKST)+4);
        TEKST:= TEKST + ')';
      end;
      if pos ('LEFT$', TEKST) > 0 then begin
        insert ('(', TEKST, pos ('LEFT$', TEKST)+5);
        TEKST:= TEKST + ')';
      end;
      if pos ('RIGHT$', TEKST) > 0 then begin
        insert ('(', TEKST, pos ('RIGHT$', TEKST)+6);
        TEKST:= TEKST + ')';
      end;
      if pos ('CHR$', TEKST) > 0 then begin
        insert ('(', TEKST, pos ('CHR$', TEKST)+4);
        TEKST:= TEKST + ')';
      end;
      INSERTBRACKETS:= TEKST;
    end;

function  CALCSTRING (TEKST : string) : string;
  var
    INTERIM : string;
    S, F    : byte; (* Start, Finish ... .... .... *)
    TEKST2  : string;
    TEKSTJE : string;
  var
    TOTALBRACKETS : integer;
    C             : byte;
    TEMP          : string;
  begin
    TRIM (TEKST);
    if TEKST[1] = '{' then
      delete (TEKST, 1,1 );
    if TEKST[length(TEKST)] = '}' then
      delete (TEKST, length (TEKST), 1);
    if not BRACKETSOK (TEKST) then begin
      exit;
    end;
    if pos (')', TEKST) = 0 then begin
      exit;
    end;
    for C:= 1 to 10 do begin {Zed .... ... .... }
      TEMP:= HAALBINNENSTE (TEKST, S, F);
      TRIM (TEMP);
      if TEMP[1] = '{' then
        delete (TEMP, 1, 1);
      if TEMP[length (TEMP)] = '}' then
        delete (TEMP, length (TEMP), 1);
      TEMP:= ANYTHING (TEMP);
      delete (TEKST, S, F-S+1);
      insert ('"'+TEMP+'"', TEKST, S);
    end;
{    TEKST2:= TEKST;
    if not BRACKETSOK (TEKST) then
      exit;
    if TEKST = '' then begin
      CALCSTRING:= '';
      exit;
    end;
    if pos (')', TEKST) = 0 then begin
      TEKST:= INSERTBRACKETS (TEKST);
      CALCSTRING:= ANYTHING(TEKST);
      exit;
    end;
    if pos (')', TEKST) = 1 then begin
      CALCSTRING:= ANYTHING (TEKST);
      exit;
    end;
    INTERIM:= HAALBINNENSTE (TEKST, S, F);
    TRIM (INTERIM);
    if INTERIM[1] = '(' then
      delete (INTERIM, 1, 1);
    if INTERIM[length(INTERIM)] = ')' then
      delete (INTERIM, length (INTERIM), 1);
    INTERIM:= INSERTBRACKETS (INTERIM);
    INTERIM:= ANYTHING (INTERIM);
    delete (TEKST, S, F-S+1);
    C:= pos ('"', Tekst2) + 1;
    TEKSTJE:= '';
    repeat
      TEKSTJE:= TEKSTJE + TEKST2[C];
      C:= C + 1;
    until (C > length (TEKST2)) or (TEKST2[C] = ')');
    insert ('"'+INTERIM+'"' + TEKSTJE, TEKST, S);
    CALCSTRING:= CALCSTRING (TEKST);
}
    CALCSTRING:= ANYTHING (TEKST);
  end;

begin
end.