
{$i-}
program TETRIS (input, output);

uses
    crt, QWKTIMER;

type
    tBlokjeSoort = set of 0..5; { important info ...... }

type
    string4    = string[21];
    tArray000  = array[0..3, 0..3] of string4; { blokjes data ...... }

type
    tLetter = record
       Ch      : char;
       Colour  : longint;
    end;

var
    Blokje               : array[0..5] of tArray000;
    CurrentBlokje, Next  : tArray000;
    Spin                 : shortint;
    I                    : longint;
    SpeelVeld            : array[-5..21, 0..33] of tLetter;
    buffer               : array[0..4007] of shortint;
    x, y                 : longint;
    Ch                   : char;
    Huidig, Volgende     : shortint;
    GAMEOVER             : BOOLEAN;
    Score, HiScore       : longint;
    Inkt                 : integer;
    Papier               : integer;
    CursorX, CursorY     : integer;
    BackScreen           : array[0..4007] of byte;

  procedure _TextColor (C : integer);
    begin
      Inkt:= C mod 16
    end;

  procedure _TextBackGround (C : integer);
    begin
      Papier:= C mod 16
    end;

  procedure _Write (Tekst : string);
    var
      mempos, c : integer;
    begin
      mempos:= ((CursorX-1)*2+(CursorY-1)*160);
      for c:= 1 to length (Tekst) do begin
         BackScreen[mempos]:= byte (Tekst[c]);
         inc (mempos, 1);
         BackScreen[mempos]:= Papier*16 + Inkt;
         inc (mempos, 1);
      end;
    end;

  procedure _GotoXY (X, Y : integer);
    begin
       CursorX:= X;
       CursorY:= Y
    end;

  procedure _ClrScr;
    var
        C : integer;
    begin
        C:= 0;
        repeat
           BackScreen[C]:= 32;
           inc (C, 1);
           BackScreen[C]:= Inkt + Papier*16;
           inc (C, 1)
        until C > 3999;
    end;

  procedure ShowScreen;
    begin
       move (BackScreen, mem[$b800:$0000], 4000)
    end;

procedure TekenBlokjeTxt (X, Y : integer);
  var
      C00 : integer;
      C01 : integer;
  begin
      for C00:= 0 to 3 do for C01:= 1 to 4 do begin
        case CurrentBlokje[Spin][C00][C01] of
           '*': begin
              _gotoxy (X+C01-1, Y+C00);
              _write (#177)
           end
        end
      end
  end;

procedure TekenNextTxt (X, Y : integer);
  var
      C00 : integer;
      C01 : integer;
  begin
      for C00:= 0 to 3 do for C01:= 1 to 4 do begin
        case Next[0][C00][C01] of
           '*': begin
              _gotoxy (X+C01-1, Y+C00);
              _write (#177)
           end
        end
      end
  end;

procedure DraaiBlokje;
  begin
     if Spin < 3 then
         inc (Spin, 1)
              else
                  Spin:= 0
  end;

function KanPlaatsen (A, B : integer) : boolean;
  label
      Eruit;
  var
      C00 : integer;
      C01 : integer;
  begin
      for C00:= 0 to 3 do for C01:= 1 to 4 do begin
        if CurrentBlokje[Spin][C00][C01] = '*' then begin
              if SpeelVeld[A+C01-1, B+C00-1].Ch = #177 then begin
                 KanPlaatsen:= false;
                 goto Eruit;
              end
        end
      end;
      KanPlaatsen:= true;
      Eruit:;
  end;

procedure PlaatsBlokje (A, B : integer);
  var
      C00 : integer;
      C01 : integer;
  begin
      for C00:= 0 to 3 do for C01:= 1 to 4 do begin
        case CurrentBlokje[Spin][C00][C01] of
           '*': begin
              SpeelVeld [A+C01-1, B+C00-1].Ch:= (#177);
              SpeelVeld [A+C01-1, B+C00-1].Colour:= Green + Spin;
           end
        end
      end
  end;



procedure SetCurrentBlock (Nummer : shortint);
  begin
      move (Blokje[Nummer], CurrentBlokje, sizeof (tArray000))
  end;

procedure SetNextBlock (Nummer : shortint);
  begin
      move (Blokje[Nummer], Next, sizeof (tArray000))
  end;


procedure LaadBlokjes;
  var
      T          : text;
      C, C0, C1  : shortint;
  begin
      assign (T, 'HISCORE.DTA');
      reset (T);
      readln (T, HiScore);
      close (T);
      assign (T, 'BLOKJES.PAS');
      reset (T);
      if ioresult <> 0 then begin
         writeln ('You need BLOKJES.PAS to run this game.');
         halt (1)
      end;
      for C:= 0 to 5 do
         for C0:= 0 to 3 do for C1:= 0 to 3 do begin
            readln (T, Blokje[C, C0, C1]);
            Blokje[C, C0, C1]:= concat (Blokje[C, C0, C1], '    ');
         end;
      close (T)
  end;

procedure ClsSpeelVeld;
     var
         X, Y : shortint;
     begin
          for X:= 1 to 16 do begin
              for Y:= 1 to 21 do
                   SpeelVeld[X, Y].Ch:= #32;
                   SpeelVeld[X, Y].Colour:= Black;
          end;
          for X:= 0 to 17 do begin
              SpeelVeld[X, 22].Ch:= #177;
              SpeelVeld[X, 23].Ch:= #177;
              SpeelVeld[X, 24].Ch:= #177;
              SpeelVeld[X, 25].Ch:= #177;
              SpeelVeld[X, 26].Ch:= #177;
              SpeelVeld[X, 27].Ch:= #177;
          end;
          for Y:= 0 to 22 do begin
              SpeelVeld[0, Y].Ch:= #177;
              SpeelVeld[17, Y].Ch:= #177;
              SpeelVeld[-1, Y].Ch:= #177;
              SpeelVeld[18, Y].Ch:= #177;
              SpeelVeld[-2, Y].Ch:= #177;
              SpeelVeld[19, Y].Ch:= #177;
              SpeelVeld[-3, Y].Ch:= #177;
              SpeelVeld[20, Y].Ch:= #177
          end;
     end;

procedure CheckAndCleanSpeelVeld;
    var
        X, Y, B    : longint;
        AllFilled  : boolean;
        c          : longint;
    begin
      for c:= 1 to 21 do
       for Y:= 21 downto 1 do begin
           AllFilled:= (SpeelVeld[1, Y].Ch = #177);
           for X:= 2 to 16 do begin
             if SpeelVeld [X, Y].Ch <> #177 then
                 AllFilled:= false;
           end;
           if AllFilled then begin
              for B:=  Y-1 downto 1 do begin
                 for X:= 1 to 16 do
                     SpeelVeld[X, B+1]:= SpeelVeld[X, B];
              end;
              for X:= 1 to 16 do begin
                  SpeelVeld [X, 1].Ch:= #32;
                  SpeelVeld [X, 1].Colour:= BLACK
              end;
              inc (Score, 50);
           end;
       end;
    end;

procedure TekenSpeelVeld;
     var
         X, Y : shortint;
     begin
          for X:= 1 to 18 do begin
              _textcolor (white);
              _gotoxy (X+12, 23);
              _write ('');
              for Y:= 1 to 23 do begin
                   _textcolor (white);
                   _gotoxy (13, Y);
                   _write ('');
                   _textcolor (white);
                   _gotoxy (13+17, Y);
                   _write ('');
                   _gotoxy (X+13, Y+1);
                   _textcolor (SpeelVeld[X, Y].Colour);
                   _write (SpeelVeld[X, Y].Ch);
              end;
          end;
          _textcolor (white);
          _gotoxy (13, 23);
          _write ('');
          _textcolor (white);
          _gotoxy (13+17, 23);
          _write ('')
     end;


var
    XPos, YPos : longint;
    A          : longint;

label
    TimePassed;

var
  T      : text;
  Tekst  : string;

begin
    nosound;
    Inkt:= LIGHTGRAY;
    Papier:= BLACK;
    CursorX:= 1;
    CursorY:= 1;
    move (mem[$b800:0], buffer, 4000);
    x:= wherex;
    y:= wherey;
    randseed:= 13;
    randomize;
    delay (8);
    randomize;
    LaadBlokjes;
   repeat
    textmode (co80);
    _textbackground (brown);
    _clrscr;
    ClsSpeelVeld;
    Volgende:= random (6);
    Huidig:= Volgende;
    repeat
        Spin:= 0;
        Ch:= #1;
        Volgende:= random (6);
        YPos:= 2;
        XPos:= 8;
        GAMEOVER:= not KanPlaatsen (XPos, YPos);
        repeat
            _clrscr;
            _textcolor (white);
            SetCurrentBlock (Volgende);
            TekenBlokjeTxt (57, 7);
            _gotoxy (57, 5);
            _write ('Next/Volgende/Prochain:');
            _gotoxy (57, 17);
            str (Score, Tekst);
            _write ('Score=   '+Tekst);
            _gotoxy (57, 21);
            str (HiScore, Tekst);
            _write ('HiScore= '+Tekst);
            SetCurrentBlock (Huidig);
            TekenSpeelVeld;
            TekenBlokjeTxt (13+XPos, YPos);
            ShowScreen;
            TimerOn (21);
            ResetTimer;
            repeat
                if Keypressed then begin
                  Ch:= readkey;
                  if Ch = #0 then begin
                     Ch:= readkey;
                     case Ch of
                        'K': if (XPos > 1) then XPos:= XPos-1;
                        'M': if KanPlaatsen (XPos+1, YPos) then XPos:= XPos+1;
                        'P': begin if YPos > 21 then inc (YPos, 1); goto TimePassed; end;
                        'H': DraaiBlokje;
                     end;
                  end;
                end;
            until TimeElapsed > 1;
            TimePassed:;
            TimerOff;
            YPos:= YPos + 1;
        until (Ch = #27) or (not KanPlaatsen (XPos, YPos)) or GAMEOVER;
        YPos:= YPos - 1;
        PlaatsBlokje (XPos, YPos);
        CheckAndCleanSpeelVeld;
        Huidig:= Volgende;
        Volgende:= random (6);
    until (Ch = #27) or GAMEOVER;
    if Score > HiScore then HiScore:= Score;
    textbackground (brown);
    textcolor (white);
    clrscr;
    writeln ('Play again? [y/n]');
    repeat
         Ch:= readkey;
    until upcase (Ch) in ['Y', 'N'];
   until upcase (Ch)='N';
{    for I:= 0 to 5 do begin
        clrscr;
        gotoxy (1, 1); write (I);
        SetCurrentBlock(I);
        TekenBlokjeTxt (5,5);
        readln;
        DraaiBlokje;
        clrscr;
        gotoxy (1, 1); write (I);
        TekenBlokjeTxt (5,5);
        readln
    end;
}
    move (buffer, mem[$b800:0], 4000);
    gotoxy (x, y);
    assign (T, 'HISCORE.DTA');
    rewrite (T);
    writeln (T, HiScore);
    close (T)
end.
+
+
+
+

